/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.auth;

import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.kie.kogito.auth.IdentityProvider;

@ApplicationScoped
public class QuarkusIdentityProvider
implements IdentityProvider {
    @Inject
    Instance<SecurityIdentity> identity;

    private Optional<SecurityIdentity> getIdentity() {
        return this.identity.isResolvable() ? Optional.of((SecurityIdentity)this.identity.get()) : Optional.empty();
    }

    @ActivateRequestContext
    public String getName() {
        return this.getIdentity().filter(securityIdentity -> !securityIdentity.isAnonymous()).map(securityIdentity -> securityIdentity.getPrincipal().getName()).orElse(null);
    }

    @ActivateRequestContext
    public Collection<String> getRoles() {
        return this.getIdentity().map(SecurityIdentity::getRoles).orElse(Collections.emptySet());
    }

    @ActivateRequestContext
    public boolean hasRole(String role) {
        return this.getIdentity().map(securityIdentity -> securityIdentity.hasRole(role)).orElse(false);
    }
}

