/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.decisions.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.DotName;
import org.kie.dmn.core.runtime.DMNRuntimeService;
import org.kie.kogito.codegen.decision.DecisionContainerGenerator;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedSourcesBuildItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionsAssetsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DecisionsAssetsProcessor.class);

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito-decisions");
    }

    @BuildStep
    public List<ReflectiveHierarchyIgnoreWarningBuildItem> reflectiveDMNREST() {
        ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem> result = new ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem>();
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.api.builder.Message$Level")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNContext")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNDecisionResult")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNDecisionResult$DecisionEvaluationStatus")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessage")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessage$Severity")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessageType")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.feel.runtime.events.FEELEvent")));
        return result;
    }

    @BuildStep
    public void stronglyTypeAdditionalClassesForReflection(KogitoGeneratedSourcesBuildItem generatedKogitoClasses, BuildProducer<ReflectiveClassBuildItem> additionalClassesForReflection, KogitoBuildContextBuildItem kogitoBuildContextBuildItem, Capabilities capabilities) {
        Optional<DecisionContainerGenerator> decisionContainerOpt = kogitoBuildContextBuildItem.getKogitoBuildContext().getApplicationSections().stream().filter(DecisionContainerGenerator.class::isInstance).map(DecisionContainerGenerator.class::cast).findFirst();
        if (decisionContainerOpt.isPresent()) {
            DecisionContainerGenerator decisionContainerGenerator = decisionContainerOpt.get();
            for (String fqcn : decisionContainerGenerator.getClassesForManualReflection()) {
                additionalClassesForReflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{fqcn}));
            }
        }
        additionalClassesForReflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.dmn.rest.KogitoDMNDecisionResult"}));
        additionalClassesForReflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.dmn.rest.KogitoDMNMessage"}));
        additionalClassesForReflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.dmn.rest.KogitoDMNResult"}));
    }

    @BuildStep
    public ReflectiveClassBuildItem dmnRuntimeServiceReflectiveClass() {
        logger.debug("dmnRuntimeServiceReflectiveClass()");
        return new ReflectiveClassBuildItem(true, true, new Class[]{DMNRuntimeService.class});
    }
}

