/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.decision.incubation.quarkus.support;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMetadata;
import org.kie.dmn.api.core.DMNResult;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.rest.DMNJSONUtils;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.decisions.LocalDecisionId;
import org.kie.kogito.incubation.decisions.LocalDecisionServiceId;
import org.kie.kogito.incubation.decisions.services.DecisionService;

@ApplicationScoped
public class QuarkusDecisionService
implements DecisionService {
    @Inject
    Instance<DecisionModels> decisionModelsInstance;

    public ExtendedDataContext evaluate(LocalId decisionId, DataContext inputContext) {
        LocalDecisionId localDecisionId;
        LocalDecisionServiceId decisionServiceId = null;
        if (decisionId instanceof LocalDecisionId) {
            localDecisionId = (LocalDecisionId)decisionId;
        } else if (decisionId instanceof LocalDecisionServiceId) {
            decisionServiceId = (LocalDecisionServiceId)decisionId;
            localDecisionId = (LocalDecisionId)decisionServiceId.decisionId();
        } else {
            throw new IllegalArgumentException("Not a valid decision id " + decisionId.toLocalId().asLocalUri());
        }
        DecisionModels decisionModels = (DecisionModels)this.decisionModelsInstance.get();
        DecisionModel decisionModel = decisionModels.getDecisionModel(localDecisionId.namespace(), localDecisionId.name());
        ExtendedDataContext extendedDataContext = (ExtendedDataContext)inputContext.as(ExtendedDataContext.class);
        Map map = ((MapDataContext)extendedDataContext.data().as(MapDataContext.class)).toMap();
        DMNContext ctx = DMNJSONUtils.ctx((DecisionModel)decisionModel, (Map)map);
        MetaDataContext inputMeta = extendedDataContext.meta();
        MapDataContext mapInputMeta = MapDataContext.from((Object)inputMeta);
        DMNMetadata metadata = ctx.getMetadata();
        for (Map.Entry kv : mapInputMeta.toMap().entrySet()) {
            metadata.set((String)kv.getKey(), kv.getValue());
        }
        DMNResult dmnResult = decisionServiceId == null ? decisionModel.evaluateAll(ctx) : decisionModel.evaluateDecisionService(ctx, decisionServiceId.serviceId());
        MapDataContext meta = MapDataContext.of((Map)dmnResult.getContext().getMetadata().asMap());
        MapDataContext data = MapDataContext.of((Map)dmnResult.getContext().getAll());
        return ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
    }
}

