/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.base.ClassFieldAccessorFactory;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.internal.jci.CompilationProblem;
import org.kie.internal.kogito.codegen.Generated;
import org.kie.internal.kogito.codegen.VariableInfo;
import org.kie.kogito.Model;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.JsonSchemaGenerator;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.quarkus.deployment.JandexProtoGenerator;
import org.kie.kogito.quarkus.deployment.KogitoCompilationProvider;
import org.kie.kogito.quarkus.deployment.MemoryClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoAssetsProcessor {
    private static final String generatedResourcesDir = System.getProperty("kogito.codegen.resources.directory", "target/generated-resources/kogito");
    private static final String generatedSourcesDir = "target/generated-sources/kogito/";
    private static final String generatedCustomizableSourcesDir = System.getProperty("kogito.codegen.sources.directory", "target/generated-sources/kogito/");
    private static final Logger logger = LoggerFactory.getLogger(KogitoAssetsProcessor.class);
    private final transient String generatedClassesDir = System.getProperty("quarkus.debug.generated-classes-dir");
    private final transient String appPackageName = "org.kie.kogito.app";
    private final transient String persistenceFactoryClass = "org.kie.kogito.persistence.KogitoProcessInstancesFactory";
    private final transient String metricsClass = "org.kie.kogito.monitoring.rest.MetricsResource";
    private final transient String tracingClass = "org.kie.kogito.tracing.decision.DecisionTracingListener";

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("kogito");
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito");
    }

    private void generatePersistenceInfo(AppPaths appPaths, BuildProducer<GeneratedBeanBuildItem> generatedBeans, IndexView index, LaunchModeBuildItem launchMode, BuildProducer<NativeImageResourceBuildItem> resource, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException, BootstrapDependencyProcessingException {
        Collection<GeneratedFile> generatedFiles;
        ClassInfo persistenceClass = index.getClassByName(this.createDotName("org.kie.kogito.persistence.KogitoProcessInstancesFactory"));
        boolean usePersistence = persistenceClass != null;
        List<String> parameters = new ArrayList<String>();
        if (usePersistence) {
            for (MethodInfo mi : persistenceClass.methods()) {
                if (!mi.name().equals("<init>") || mi.parameters().isEmpty()) continue;
                parameters = mi.parameters().stream().map(p -> p.name().toString()).collect(Collectors.toList());
                break;
            }
        }
        if (!(generatedFiles = this.getGeneratedPersistenceFiles(appPaths, index, usePersistence, parameters)).isEmpty()) {
            MemoryFileSystem trgMfs = new MemoryFileSystem();
            CompilationResult result = this.compile(appPaths, trgMfs, curateOutcomeBuildItem.getEffectiveModel(), generatedFiles, launchMode.getLaunchMode());
            this.register(appPaths, trgMfs, generatedBeans, GeneratedBeanBuildItem::new, launchMode.getLaunchMode(), result);
        }
        if (usePersistence) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"kogito-types.proto"}));
        }
    }

    private Collection<GeneratedFile> getGeneratedPersistenceFiles(AppPaths appPaths, IndexView index, boolean usePersistence, List<String> parameters) {
        GeneratorContext context = this.buildContext(appPaths, index);
        Collection modelClasses = index.getAllKnownImplementors(this.createDotName(Model.class.getCanonicalName()));
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        for (Path projectPath : appPaths.projectPaths) {
            PersistenceGenerator persistenceGenerator = new PersistenceGenerator(new File(projectPath.toFile(), "target"), modelClasses, usePersistence, (ProtoGenerator)new JandexProtoGenerator(index, this.createDotName(Generated.class.getCanonicalName()), this.createDotName(VariableInfo.class.getCanonicalName())), parameters);
            persistenceGenerator.setDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
            persistenceGenerator.setPackageName("org.kie.kogito.app");
            persistenceGenerator.setContext(context);
            generatedFiles.addAll(persistenceGenerator.generate());
        }
        return generatedFiles;
    }

    private Collection<GeneratedFile> getJsonSchemaFiles(Index index, MemoryFileSystem trgMfs) throws IOException {
        MemoryClassLoader cl = new MemoryClassLoader(trgMfs, Thread.currentThread().getContextClassLoader());
        return new JsonSchemaGenerator.Builder(index.getAnnotations(this.createDotName(UserTask.class.getCanonicalName())).stream().map(instance -> {
            try {
                return cl.loadClass(instance.target().toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        })).withGenSchemaPredicate(x -> true).withSchemaVersion(System.getProperty("kogito.jsonSchema.version")).build().generate();
    }

    @BuildStep
    public List<ReflectiveHierarchyIgnoreWarningBuildItem> reflectiveDMNREST() {
        ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem> result = new ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem>();
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.api.builder.Message$Level")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNContext")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNDecisionResult")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNDecisionResult$DecisionEvaluationStatus")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessage")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessage$Severity")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessageType")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.feel.runtime.events.FEELEvent")));
        return result;
    }

    @BuildStep
    public RuntimeInitializedClassBuildItem runtimeInitializedClass() {
        return new RuntimeInitializedClassBuildItem(ClassFieldAccessorFactory.class.getName());
    }

    @BuildStep(loadsApplicationClasses=true)
    public void generateModel(ArchiveRootBuildItem root, BuildProducer<GeneratedBeanBuildItem> generatedBeans, CombinedIndexBuildItem combinedIndexBuildItem, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException, BootstrapDependencyProcessingException {
        if (liveReload.isLiveReload()) {
            return;
        }
        AppPaths appPaths = new AppPaths(root.getPaths());
        ApplicationGenerator appGen = this.createApplicationGenerator(appPaths, combinedIndexBuildItem);
        Collection generatedFiles = appGen.generate();
        Collection javaFiles = generatedFiles.stream().filter(f -> f.relativePath().endsWith(".java")).collect(Collectors.toCollection(ArrayList::new));
        this.writeGeneratedFiles(appPaths, generatedFiles);
        if (!javaFiles.isEmpty()) {
            Indexer kogitoIndexer = new Indexer();
            HashSet kogitoIndex = new HashSet();
            MemoryFileSystem trgMfs = new MemoryFileSystem();
            CompilationResult result = this.compile(appPaths, trgMfs, curateOutcomeBuildItem.getEffectiveModel(), javaFiles, launchMode.getLaunchMode());
            this.register(appPaths, trgMfs, generatedBeans, (className, data) -> this.generateBeanBuildItem(combinedIndexBuildItem, kogitoIndexer, kogitoIndex, (String)className, (byte[])data), launchMode.getLaunchMode(), result);
            Index index = kogitoIndexer.complete();
            this.generatePersistenceInfo(appPaths, generatedBeans, (IndexView)CompositeIndex.create((IndexView[])new IndexView[]{combinedIndexBuildItem.getIndex(), index}), launchMode, resource, curateOutcomeBuildItem);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.event.AbstractDataEvent"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.AbstractProcessDataEvent"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.ProcessInstanceDataEvent"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.VariableInstanceDataEvent"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessInstanceEventBody"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.NodeInstanceEventBody"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessErrorEventBody"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.VariableInstanceEventBody"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.UserTaskInstanceDataEvent"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.UserTaskInstanceEventBody"}));
            Collection dataEvents = index.getAllKnownSubclasses(this.createDotName("org.kie.kogito.event.AbstractDataEvent"));
            dataEvents.forEach(c -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.name().toString()})));
            this.writeGeneratedFiles(appPaths, this.getJsonSchemaFiles(index, trgMfs));
        }
    }

    private void writeGeneratedFiles(AppPaths appPaths, Collection<GeneratedFile> resourceFiles) {
        for (Path projectPath : appPaths.projectPaths) {
            String restResourcePath = projectPath.resolve(generatedCustomizableSourcesDir).toString();
            String resourcePath = projectPath.resolve(generatedResourcesDir).toString();
            String jsonSchemaPath = projectPath.resolve(generatedResourcesDir).resolve("jsonSchema").toString();
            String sourcePath = projectPath.resolve(generatedSourcesDir).toString();
            for (GeneratedFile f : resourceFiles) {
                try {
                    if (f.getType() == GeneratedFile.Type.RESOURCE) {
                        this.writeGeneratedFile(f, resourcePath);
                        continue;
                    }
                    if (f.getType() == GeneratedFile.Type.JSON_SCHEMA) {
                        this.writeGeneratedFile(f, jsonSchemaPath);
                        continue;
                    }
                    if (f.getType().isCustomizable()) {
                        this.writeGeneratedFile(f, restResourcePath);
                        continue;
                    }
                    this.writeGeneratedFile(f, sourcePath);
                }
                catch (IOException e) {
                    logger.warn(String.format("Could not write file '%s'", f.toString()), (Throwable)e);
                }
            }
        }
    }

    private GeneratedBeanBuildItem generateBeanBuildItem(CombinedIndexBuildItem combinedIndexBuildItem, Indexer kogitoIndexer, Set<DotName> kogitoIndex, String className, byte[] data) {
        IndexingUtil.indexClass((String)className, (Indexer)kogitoIndexer, (IndexView)combinedIndexBuildItem.getIndex(), kogitoIndex, (ClassLoader)Thread.currentThread().getContextClassLoader(), (byte[])data);
        return new GeneratedBeanBuildItem(className, data);
    }

    private CompilationResult compile(AppPaths appPaths, MemoryFileSystem trgMfs, AppModel appModel, Collection<GeneratedFile> generatedFiles, LaunchMode launchMode) throws IOException {
        JavaCompiler javaCompiler = JavaParserCompiler.getCompiler();
        JavaCompilerSettings compilerSettings = javaCompiler.createDefaultSettings();
        compilerSettings.addOption("-proc:none");
        for (Path classPath : appPaths.classesPaths) {
            compilerSettings.addClasspath(classPath.toString());
        }
        if (appModel != null) {
            for (AppDependency i : appModel.getUserDependencies()) {
                compilerSettings.addClasspath(i.getArtifact().getPaths().getSinglePath().toAbsolutePath().toString());
            }
        }
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        String[] sources = new String[generatedFiles.size()];
        int index = 0;
        for (GeneratedFile entry : generatedFiles) {
            String generatedClassFile = entry.relativePath().replace("src/main/java/", "");
            String fileName = this.toRuntimeSource(this.toClassName(generatedClassFile));
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.contents());
            String location = this.generatedClassesDir;
            if (launchMode == LaunchMode.DEVELOPMENT) {
                location = Paths.get(appPaths.getFirstClassesPath().toString(), new String[0]).toString();
            }
            this.writeGeneratedFile(entry, location);
        }
        return javaCompiler.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, Thread.currentThread().getContextClassLoader(), compilerSettings);
    }

    private void register(AppPaths appPaths, MemoryFileSystem trgMfs, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BiFunction<String, byte[], GeneratedBeanBuildItem> bif, LaunchMode launchMode, CompilationResult result) throws IOException {
        if (result.getErrors().length > 0) {
            StringBuilder errorInfo = new StringBuilder();
            for (CompilationProblem compilationProblem : result.getErrors()) {
                errorInfo.append(compilationProblem.toString());
                errorInfo.append("\n");
                logger.error(compilationProblem.toString());
            }
            Arrays.stream(result.getErrors()).forEach(cp -> errorInfo.append(cp.toString()));
            throw new IllegalStateException(errorInfo.toString());
        }
        for (String fileName : trgMfs.getFileNames()) {
            byte[] data = trgMfs.getBytes(fileName);
            String className = this.toClassName(fileName);
            generatedBeans.produce((BuildItem)bif.apply(className, data));
            if (launchMode != LaunchMode.DEVELOPMENT) continue;
            Path path = this.writeFile(Paths.get(appPaths.getFirstClassesPath().toString(), fileName).toString(), data);
            String sourceFile = path.toString().replaceFirst("\\.class", ".java");
            if (sourceFile.contains("$")) {
                sourceFile = sourceFile.substring(0, sourceFile.indexOf("$")) + ".java";
            }
            KogitoCompilationProvider.classToSource.put(path, Paths.get(sourceFile, new String[0]));
        }
    }

    private Path writeFile(String fileName, byte[] data) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.write(path, data, new OpenOption[0]);
        return path;
    }

    private ApplicationGenerator createApplicationGenerator(AppPaths appPaths, CombinedIndexBuildItem combinedIndexBuildItem) throws IOException {
        boolean usePersistence = combinedIndexBuildItem.getIndex().getClassByName(this.createDotName("org.kie.kogito.persistence.KogitoProcessInstancesFactory")) != null;
        boolean useMonitoring = combinedIndexBuildItem.getIndex().getClassByName(this.createDotName("org.kie.kogito.monitoring.rest.MetricsResource")) != null;
        boolean useTracing = !combinedIndexBuildItem.getIndex().getAllKnownSubclasses(this.createDotName("org.kie.kogito.tracing.decision.DecisionTracingListener")).isEmpty();
        GeneratorContext context = this.buildContext(appPaths, combinedIndexBuildItem.getIndex());
        ApplicationGenerator appGen = new ApplicationGenerator("org.kie.kogito.app", new File(appPaths.getFirstProjectPath().toFile(), "target")).withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator()).withPersistence(usePersistence).withMonitoring(useMonitoring).withGeneratorContext(context);
        this.addProcessGenerator(appPaths, usePersistence, appGen);
        this.addRuleGenerator(appPaths, appGen, useMonitoring);
        this.addDecisionGenerator(appPaths, appGen, useMonitoring, useTracing);
        return appGen;
    }

    private void addRuleGenerator(AppPaths appPaths, ApplicationGenerator appGen, boolean useMonitoring) throws IOException {
        IncrementalRuleCodegen generator = appPaths.isJar ? IncrementalRuleCodegen.ofJar((Path[])appPaths.getJarPath()) : IncrementalRuleCodegen.ofPath((Path[])appPaths.getSourcePaths());
        ((IncrementalRuleCodegen)appGen.withGenerator((Generator)generator)).withKModule(this.findKieModuleModel(appPaths)).withMonitoring(useMonitoring).withClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private KieModuleModel findKieModuleModel(AppPaths appPaths) throws IOException {
        for (Path resourcePath : appPaths.getResourcePaths()) {
            Path moduleXmlPath = resourcePath.resolve("META-INF/kmodule.xml");
            if (!Files.exists(moduleXmlPath, new LinkOption[0])) continue;
            return KieModuleModelImpl.fromXML((InputStream)new ByteArrayInputStream(Files.readAllBytes(moduleXmlPath)));
        }
        return KieModuleModelImpl.fromXML((String)"<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>");
    }

    private void addProcessGenerator(AppPaths appPaths, boolean usePersistence, ApplicationGenerator appGen) throws IOException {
        ProcessCodegen generator = appPaths.isJar ? ProcessCodegen.ofJar((Path[])appPaths.getJarPath()) : ProcessCodegen.ofPath((Path[])appPaths.getProjectPaths());
        ((ProcessCodegen)appGen.withGenerator((Generator)generator)).withPersistence(usePersistence).withClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private void addDecisionGenerator(AppPaths appPaths, ApplicationGenerator appGen, boolean useMonitoring, boolean useTracing) throws IOException {
        DecisionCodegen generator = appPaths.isJar ? DecisionCodegen.ofJar((Path[])appPaths.getJarPath()) : DecisionCodegen.ofPath((Path[])appPaths.getResourcePaths());
        ((DecisionCodegen)appGen.withGenerator((Generator)generator.withTracing(useTracing))).withMonitoring(useMonitoring);
    }

    private String toRuntimeSource(String className) {
        return "src/main/java/" + className.replace('.', '/') + ".java";
    }

    private String toClassName(String sourceName) {
        if (sourceName.startsWith("./")) {
            sourceName = sourceName.substring(2);
        }
        if (sourceName.endsWith(".java")) {
            sourceName = sourceName.substring(0, sourceName.length() - 5);
        } else if (sourceName.endsWith(".class")) {
            sourceName = sourceName.substring(0, sourceName.length() - 6);
        }
        return sourceName.replace('/', '.');
    }

    private void writeGeneratedFile(GeneratedFile f, String location) throws IOException {
        if (location == null) {
            return;
        }
        String generatedClassFile = f.relativePath().replace("src/main/java", "");
        Files.write(this.pathOf(location, generatedClassFile), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(String location, String end) {
        Path path = Paths.get(location, end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    private DotName createDotName(String name) {
        int lastDot = name.indexOf(46);
        if (lastDot < 0) {
            return DotName.createComponentized(null, (String)name);
        }
        DotName lastDotName = null;
        while (lastDot > 0) {
            String local = name.substring(0, lastDot);
            name = name.substring(lastDot + 1);
            lastDot = name.indexOf(46);
            lastDotName = DotName.createComponentized(lastDotName, (String)local);
        }
        int lastDollar = name.indexOf(36);
        if (lastDollar < 0) {
            return DotName.createComponentized(lastDotName, (String)name);
        }
        DotName lastDollarName = null;
        while (lastDollar > 0) {
            String local = name.substring(0, lastDollar);
            name = name.substring(lastDollar + 1);
            lastDollar = name.indexOf(36);
            if (lastDollarName == null) {
                lastDollarName = DotName.createComponentized((DotName)lastDotName, (String)local);
                continue;
            }
            lastDollarName = DotName.createComponentized((DotName)lastDollarName, (String)local, (boolean)true);
        }
        return DotName.createComponentized(lastDollarName, (String)name, (boolean)true);
    }

    private GeneratorContext buildContext(AppPaths appPaths, IndexView index) {
        GeneratorContext context = GeneratorContext.ofResourcePath((File[])appPaths.getResourceFiles());
        context.withBuildContext((KogitoBuildContext)new QuarkusKogitoBuildContext(className -> {
            DotName classDotName = this.createDotName((String)className);
            return !index.getAnnotations(classDotName).isEmpty() || index.getClassByName(classDotName) != null;
        }));
        return context;
    }

    private static class AppPaths {
        private final Set<Path> projectPaths = new LinkedHashSet<Path>();
        private final List<Path> classesPaths = new ArrayList<Path>();
        private boolean isJar = false;

        private AppPaths(PathsCollection paths) {
            for (Path path : paths) {
                PathType pathType = this.getPathType(path);
                switch (pathType) {
                    case CLASSES: {
                        this.classesPaths.add(path);
                        this.projectPaths.add(path.getParent().getParent());
                        break;
                    }
                    case TEST_CLASSES: {
                        this.projectPaths.add(path.getParent().getParent());
                        break;
                    }
                    case JAR: {
                        this.isJar = true;
                        this.classesPaths.add(path);
                        this.projectPaths.add(path.getParent().getParent());
                        break;
                    }
                    case UNKNOWN: {
                        this.classesPaths.add(path);
                        this.projectPaths.add(path);
                    }
                }
            }
        }

        public Path getFirstProjectPath() {
            return this.projectPaths.iterator().next();
        }

        public Path getFirstClassesPath() {
            return this.classesPaths.get(0);
        }

        public Path[] getJarPath() {
            if (!this.isJar) {
                throw new IllegalStateException("Not a jar");
            }
            return this.classesPaths.toArray(new Path[this.classesPaths.size()]);
        }

        public File[] getResourceFiles() {
            return (File[])this.projectPaths.stream().map(p -> p.resolve("src/main/resources").toFile()).toArray(File[]::new);
        }

        public Path[] getResourcePaths() {
            return this.transformPaths(this.projectPaths, p -> p.resolve("src/main/resources"));
        }

        public Path[] getSourcePaths() {
            return this.transformPaths(this.projectPaths, p -> p.resolve("src"));
        }

        public Path[] getProjectPaths() {
            return this.transformPaths(this.projectPaths, Function.identity());
        }

        private Path[] transformPaths(Collection<Path> paths, Function<Path, Path> f) {
            return (Path[])paths.stream().map(f).toArray(Path[]::new);
        }

        private PathType getPathType(Path archiveLocation) {
            String path = archiveLocation.toString();
            if (path.endsWith("target" + File.separator + "classes")) {
                return PathType.CLASSES;
            }
            if (path.endsWith("target" + File.separator + "test-classes")) {
                return PathType.TEST_CLASSES;
            }
            if (path.endsWith(".jar")) {
                return PathType.JAR;
            }
            return PathType.UNKNOWN;
        }

        private static enum PathType {
            CLASSES,
            TEST_CLASSES,
            JAR,
            UNKNOWN;

        }
    }
}

