/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import org.kie.kogito.codegen.GeneratedFile;

public class GeneratedFileWriter {
    private final Path classesDir;
    private final Path sourcesDir;
    private final Path resourcePath;
    private final Path scaffoldedSourcesDir;

    public GeneratedFileWriter(Path classesDir, Path sourcesDir, Path resourcePath, Path scaffoldedSourcesDir) {
        this.classesDir = classesDir;
        this.sourcesDir = sourcesDir;
        this.resourcePath = resourcePath;
        this.scaffoldedSourcesDir = scaffoldedSourcesDir;
    }

    public void writeAll(Collection<GeneratedFile> generatedFiles) {
        generatedFiles.forEach(this::write);
    }

    public void write(GeneratedFile f) throws UncheckedIOException {
        try {
            GeneratedFile.Type type = f.getType();
            switch (type) {
                case RESOURCE: {
                    this.writeGeneratedFile(f, this.resourcePath);
                    break;
                }
                case GENERATED_CP_RESOURCE: {
                    this.writeGeneratedFile(f, this.classesDir);
                    break;
                }
                default: {
                    if (type.isCustomizable()) {
                        this.writeGeneratedFile(f, this.scaffoldedSourcesDir);
                        break;
                    }
                    this.writeGeneratedFile(f, this.sourcesDir);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeGeneratedFile(GeneratedFile f, Path location) throws IOException {
        if (location == null) {
            return;
        }
        String generatedClassFile = f.relativePath().replace("src/main/java", "");
        Files.write(this.pathOf(location, generatedClassFile), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(Path location, String end) {
        Path path = location.resolve(end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    public static class Builder {
        private final String classesDir;
        private final String sourcesDir;
        private final String resourcePath;
        private final String scaffoldedSourcesDir;

        public Builder(String classesDir, String sourcesDir, String resourcesDir, String scaffoldedSourcesDir) {
            this.classesDir = classesDir;
            this.sourcesDir = sourcesDir;
            this.resourcePath = resourcesDir;
            this.scaffoldedSourcesDir = scaffoldedSourcesDir;
        }

        public GeneratedFileWriter build(Path basePath) {
            return new GeneratedFileWriter(basePath.resolve(this.classesDir), basePath.resolve(this.sourcesDir), basePath.resolve(this.resourcePath), basePath.resolve(this.scaffoldedSourcesDir));
        }
    }
}

