/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.drools.compiler.builder.impl.KogitoKieModuleModelImpl;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.core.base.ClassFieldAccessorFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.pmml.PMML4Result;
import org.kie.internal.kogito.codegen.Generated;
import org.kie.internal.kogito.codegen.VariableInfo;
import org.kie.kogito.Model;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.JsonSchemaGenerator;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.io.CollectedResource;
import org.kie.kogito.codegen.prediction.PredictionCodegen;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.event.AbstractDataEvent;
import org.kie.kogito.quarkus.deployment.AppPaths;
import org.kie.kogito.quarkus.deployment.GeneratedFileWriter;
import org.kie.kogito.quarkus.deployment.InMemoryCompiler;
import org.kie.kogito.quarkus.deployment.JandexProtoGenerator;
import org.kie.kogito.quarkus.deployment.KogitoCompilationProvider;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluatorFinderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoAssetsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KogitoAssetsProcessor.class);
    public static final String targetClassesDir = "target/classes";
    private static final GeneratedFileWriter.Builder generatedFileWriterBuilder = new GeneratedFileWriter.Builder("target/classes", System.getProperty("kogito.codegen.sources.directory", "target/generated-sources/kogito/"), System.getProperty("kogito.codegen.resources.directory", "target/generated-resources/kogito/"), "target/generated-sources/kogito/");
    private static final String appPackageName = "org.kie.kogito.app";
    private static final DotName persistenceFactoryClass = DotName.createSimple((String)"org.kie.kogito.persistence.KogitoProcessInstancesFactory");
    private static final DotName metricsClass = DotName.createSimple((String)"org.kie.kogito.monitoring.rest.MetricsResource");
    private static final DotName tracingClass = DotName.createSimple((String)"org.kie.kogito.tracing.decision.DecisionTracingListener");
    private static final DotName knativeEventingClass = DotName.createSimple((String)"org.kie.kogito.events.knative.ce.extensions.KogitoProcessExtension");
    private static final DotName dmnJpmmlClass = DotName.createSimple((String)"org.kie.dmn.jpmml.DMNjPMMLInvocationEvaluator");
    @Inject
    ArchiveRootBuildItem root;
    @Inject
    LiveReloadBuildItem liveReload;
    @Inject
    CurateOutcomeBuildItem curateOutcomeBuildItem;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    BuildProducer<GeneratedBeanBuildItem> generatedBeans;
    @Inject
    BuildProducer<NativeImageResourceBuildItem> resource;
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    BuildProducer<GeneratedResourceBuildItem> genResBI;

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("kogito");
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito");
    }

    @BuildStep
    public void generateModel() throws IOException {
        if (this.liveReload.isLiveReload()) {
            return;
        }
        AppPaths appPaths = new AppPaths(this.root.getPaths());
        boolean usePersistence = this.combinedIndexBuildItem.getIndex().getClassByName(persistenceFactoryClass) != null;
        boolean useMonitoring = this.combinedIndexBuildItem.getIndex().getClassByName(metricsClass) != null;
        boolean useTracing = !this.combinedIndexBuildItem.getIndex().getAllKnownSubclasses(tracingClass).isEmpty();
        boolean useKnativeEventing = this.combinedIndexBuildItem.getIndex().getClassByName(knativeEventingClass) != null;
        boolean isJPMMLAvailable = this.combinedIndexBuildItem.getIndex().getClassByName(dmnJpmmlClass) != null;
        AddonsConfig addonsConfig = new AddonsConfig().withPersistence(usePersistence).withMonitoring(useMonitoring).withTracing(useTracing).withKnativeEventing(useKnativeEventing);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        GeneratorContext context = this.buildContext(appPaths, this.combinedIndexBuildItem.getIndex());
        Path[] paths = appPaths.getPath();
        ApplicationGenerator appGen = new ApplicationGenerator(appPackageName, new File(appPaths.getFirstProjectPath().toFile(), "target")).withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator()).withAddons(addonsConfig).withGeneratorContext(context);
        ((ProcessCodegen)appGen.withGenerator((Generator)ProcessCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])paths)))).withAddons(addonsConfig).withClassLoader(classLoader);
        ((IncrementalRuleCodegen)appGen.withGenerator((Generator)IncrementalRuleCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])paths)))).withKModule(this.findKieModuleModel(appPaths)).withAddons(addonsConfig).withClassLoader(classLoader);
        ((PredictionCodegen)appGen.withGenerator((Generator)PredictionCodegen.ofCollectedResources((boolean)isJPMMLAvailable, (Collection)CollectedResource.fromPaths((Path[])paths)))).withAddons(addonsConfig);
        ((DecisionCodegen)appGen.withGenerator((Generator)DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])paths)))).withAddons(addonsConfig).withClassLoader(classLoader);
        Collection generatedFiles = appGen.generate();
        for (Path projectPath : appPaths.projectPaths) {
            generatedFileWriterBuilder.build(projectPath).writeAll(generatedFiles);
        }
        this.registerResources(generatedFiles);
        Index index = this.processGeneratedJavaSourceCode(appPaths, generatedFiles);
        if (index == null) {
            return;
        }
        this.generatePersistenceInfo(appPaths, (IndexView)index);
        this.registerDataEventsForReflection(index);
        this.writeJsonSchema(appPaths, index);
    }

    private void registerResources(Collection<GeneratedFile> generatedFiles) {
        for (GeneratedFile f : generatedFiles) {
            if (f.getType() != GeneratedFile.Type.GENERATED_CP_RESOURCE) continue;
            this.genResBI.produce((BuildItem)new GeneratedResourceBuildItem(f.relativePath(), f.contents()));
            this.resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{f.relativePath()}));
        }
    }

    private Index processGeneratedJavaSourceCode(AppPaths appPaths, Collection<GeneratedFile> generatedFiles) throws IOException {
        Collection javaFiles = generatedFiles.stream().filter(f -> f.relativePath().endsWith(".java")).collect(Collectors.toList());
        if (javaFiles.isEmpty()) {
            return null;
        }
        InMemoryCompiler inMemoryCompiler = new InMemoryCompiler(appPaths.classesPaths, this.curateOutcomeBuildItem.getEffectiveModel().getUserDependencies());
        inMemoryCompiler.compile(javaFiles);
        MemoryFileSystem trgMfs = inMemoryCompiler.getTargetFileSystem();
        Collection<GeneratedBeanBuildItem> generatedBeanBuildItems = this.makeBuildItems(appPaths, trgMfs);
        generatedBeanBuildItems.forEach(arg_0 -> this.generatedBeans.produce(arg_0));
        return this.indexBuildItems(generatedBeanBuildItems);
    }

    private void generatePersistenceInfo(AppPaths appPaths, IndexView inputIndex) throws IOException {
        String persistenceType;
        GeneratorContext context;
        Collection<GeneratedFile> generatedFiles;
        CompositeIndex index = CompositeIndex.create((IndexView[])new IndexView[]{this.combinedIndexBuildItem.getIndex(), inputIndex});
        ClassInfo persistenceClass = index.getClassByName(persistenceFactoryClass);
        boolean usePersistence = persistenceClass != null;
        List<String> parameters = new ArrayList<String>();
        if (usePersistence) {
            for (MethodInfo mi : persistenceClass.methods()) {
                if (!mi.name().equals("<init>") || mi.parameters().isEmpty()) continue;
                parameters = mi.parameters().stream().map(p -> p.name().toString()).collect(Collectors.toList());
                break;
            }
        }
        if (!(generatedFiles = this.getGeneratedPersistenceFiles(appPaths, (IndexView)index, usePersistence, parameters, context = this.buildContext(appPaths, (IndexView)index), persistenceType = context.getApplicationProperty("kogito.persistence.type").orElse("infinispan"))).isEmpty()) {
            InMemoryCompiler inMemoryCompiler = new InMemoryCompiler(appPaths.classesPaths, this.curateOutcomeBuildItem.getEffectiveModel().getUserDependencies());
            inMemoryCompiler.compile(generatedFiles);
            Collection<GeneratedBeanBuildItem> generatedBeanBuildItems = this.makeBuildItems(appPaths, inMemoryCompiler.getTargetFileSystem());
            generatedBeanBuildItems.forEach(arg_0 -> this.generatedBeans.produce(arg_0));
        }
        if (usePersistence) {
            this.resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"kogito-types.proto"}));
        }
        if (persistenceType.equals("mongodb")) {
            this.addInnerClasses(JBPMMessages.class, this.reflectiveClass);
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"java.lang.String"}));
        }
    }

    private void addInnerClasses(Class<?> superClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Arrays.asList(superClass.getDeclaredClasses()).forEach(c -> {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.getName()}));
            this.addInnerClasses((Class<?>)c, reflectiveClass);
        });
    }

    private Collection<GeneratedFile> getGeneratedPersistenceFiles(AppPaths appPaths, IndexView index, boolean usePersistence, List<String> parameters, GeneratorContext context, String persistenceType) {
        JandexProtoGenerator jandexProtoGenerator = new JandexProtoGenerator(index, DotName.createSimple((String)Generated.class.getCanonicalName()), DotName.createSimple((String)VariableInfo.class.getCanonicalName()));
        Collection modelClasses = index.getAllKnownImplementors(DotName.createSimple((String)Model.class.getCanonicalName()));
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        for (Path projectPath : appPaths.projectPaths) {
            PersistenceGenerator persistenceGenerator = this.makePersistenceGenerator(usePersistence, parameters, context, modelClasses, jandexProtoGenerator, projectPath, persistenceType);
            generatedFiles.addAll(persistenceGenerator.generate());
        }
        return generatedFiles;
    }

    private PersistenceGenerator makePersistenceGenerator(boolean usePersistence, List<String> parameters, GeneratorContext context, Collection<ClassInfo> modelClasses, JandexProtoGenerator jandexProtoGenerator, Path projectPath, String persistenceType) {
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(new File(projectPath.toFile(), "target"), modelClasses, usePersistence, (ProtoGenerator)jandexProtoGenerator, parameters, persistenceType);
        persistenceGenerator.setDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
        persistenceGenerator.setPackageName(appPackageName);
        persistenceGenerator.setContext(context);
        return persistenceGenerator;
    }

    private Collection<GeneratedFile> getJsonSchemaFiles(Path path, Index index) throws IOException {
        URL[] urls = new URL[]{path.toUri().toURL()};
        URLClassLoader cl = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        List annotations = index.getAnnotations(DotName.createSimple((String)UserTask.class.getCanonicalName()));
        JsonSchemaGenerator.SimpleBuilder simpleBuilder = new JsonSchemaGenerator.SimpleBuilder((ClassLoader)cl).withSchemaVersion(System.getProperty("kogito.jsonSchema.version"));
        for (AnnotationInstance ann : annotations) {
            String processName = ann.value("processName").asString();
            String taskName = ann.value("taskName").asString();
            simpleBuilder.addSchemaName(ann.target().asClass().name().toString(), processName, taskName);
        }
        return simpleBuilder.build().generate();
    }

    @BuildStep
    public List<ReflectiveHierarchyIgnoreWarningBuildItem> reflectiveDMNREST() {
        ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem> result = new ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem>();
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.api.builder.Message$Level")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNContext")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNDecisionResult")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNDecisionResult$DecisionEvaluationStatus")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessage")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessage$Severity")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessageType")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.feel.runtime.events.FEELEvent")));
        return result;
    }

    @BuildStep
    public RuntimeInitializedClassBuildItem runtimeInitializedClass() {
        return new RuntimeInitializedClassBuildItem(ClassFieldAccessorFactory.class.getName());
    }

    @BuildStep
    public List<ReflectiveClassBuildItem> reflectivePredictions() {
        logger.debug("reflectivePredictions()");
        PMMLModelEvaluatorFinderImpl pmmlModelEvaluatorFinder = new PMMLModelEvaluatorFinderImpl();
        List pmmlEvaluators = pmmlModelEvaluatorFinder.getImplementations(false);
        logger.debug("pmmlEvaluators {}", (Object)pmmlEvaluators.size());
        ArrayList<ReflectiveClassBuildItem> toReturn = new ArrayList<ReflectiveClassBuildItem>();
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{PMML4Result.class}));
        pmmlEvaluators.forEach(pmmlModelEvaluator -> toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{pmmlModelEvaluator.getClass()})));
        logger.debug("toReturn {}", (Object)toReturn.size());
        return toReturn;
    }

    @BuildStep
    public NativeImageResourceBuildItem predictionSPI() {
        logger.debug("predictionSPI()");
        return new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.kie.pmml.evaluator.core.executor.PMMLModelEvaluator"});
    }

    private void writeJsonSchema(AppPaths appPaths, Index index) throws IOException {
        Path relativePath = JsonSchemaUtil.getJsonDir();
        Path targetClasses = appPaths.getFirstProjectPath().resolve(targetClassesDir);
        Collection<GeneratedFile> jsonFiles = this.getJsonSchemaFiles(targetClasses, index);
        Path jsonSchemaPath = targetClasses.resolve(relativePath);
        Files.createDirectories(jsonSchemaPath, new FileAttribute[0]);
        for (GeneratedFile jsonFile : jsonFiles) {
            Files.write(jsonSchemaPath.resolve(jsonFile.relativePath()), jsonFile.contents(), new OpenOption[0]);
            this.resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{relativePath.resolve(jsonFile.relativePath()).toString()}));
        }
    }

    private void registerDataEventsForReflection(Index index) {
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.event.AbstractDataEvent"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.AbstractProcessDataEvent"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.ProcessInstanceDataEvent"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.VariableInstanceDataEvent"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessInstanceEventBody"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.NodeInstanceEventBody"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessErrorEventBody"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.VariableInstanceEventBody"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.UserTaskInstanceDataEvent"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.UserTaskInstanceEventBody"}));
        this.addChildrenClasses(index, AbstractDataEvent.class, this.reflectiveClass);
        this.addChildrenClasses(index, AbstractProcessDataEvent.class, this.reflectiveClass);
    }

    private void addChildrenClasses(Index index, Class<?> superClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        index.getAllKnownSubclasses(DotName.createSimple((String)superClass.getCanonicalName())).forEach(c -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.name().toString()})));
    }

    private Index indexBuildItems(Collection<GeneratedBeanBuildItem> buildItems) {
        Indexer kogitoIndexer = new Indexer();
        HashSet kogitoIndex = new HashSet();
        for (GeneratedBeanBuildItem generatedBeanBuildItem : buildItems) {
            IndexingUtil.indexClass((String)generatedBeanBuildItem.getName(), (Indexer)kogitoIndexer, (IndexView)this.combinedIndexBuildItem.getIndex(), kogitoIndex, (ClassLoader)Thread.currentThread().getContextClassLoader(), (byte[])generatedBeanBuildItem.getData());
        }
        return kogitoIndexer.complete();
    }

    private Collection<GeneratedBeanBuildItem> makeBuildItems(AppPaths appPaths, MemoryFileSystem trgMfs) throws IOException {
        ArrayList<GeneratedBeanBuildItem> buildItems = new ArrayList<GeneratedBeanBuildItem>();
        Path location = appPaths.getFirstProjectPath().resolve(targetClassesDir);
        for (String fileName : trgMfs.getFileNames()) {
            byte[] data = trgMfs.getBytes(fileName);
            String className = this.toClassName(fileName);
            buildItems.add(new GeneratedBeanBuildItem(className, data));
            Path path = this.pathOf(location.toString(), fileName);
            Files.write(path, data, new OpenOption[0]);
            String sourceFile = location.toString().replaceFirst("\\.class", ".java");
            if (sourceFile.contains("$")) {
                sourceFile = sourceFile.substring(0, sourceFile.indexOf("$")) + ".java";
            }
            KogitoCompilationProvider.classToSource.put(path, Paths.get(sourceFile, new String[0]));
        }
        return buildItems;
    }

    private KieModuleModel findKieModuleModel(AppPaths appPaths) throws IOException {
        for (Path resourcePath : appPaths.getResourcePaths()) {
            Path moduleXmlPath = resourcePath.resolve("META-INF/kmodule.xml");
            if (!Files.exists(moduleXmlPath, new LinkOption[0])) continue;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(Files.readAllBytes(moduleXmlPath));){
                KieModuleModel kieModuleModel = KogitoKieModuleModelImpl.fromXML((InputStream)bais);
                return kieModuleModel;
            }
        }
        return KogitoKieModuleModelImpl.fromXML((String)"<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>");
    }

    private String toClassName(String sourceName) {
        if (sourceName.startsWith("./")) {
            sourceName = sourceName.substring(2);
        }
        if (sourceName.endsWith(".java")) {
            sourceName = sourceName.substring(0, sourceName.length() - 5);
        } else if (sourceName.endsWith(".class")) {
            sourceName = sourceName.substring(0, sourceName.length() - 6);
        }
        return sourceName.replace('/', '.');
    }

    private Path pathOf(String location, String end) {
        Path path = Paths.get(location, end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    private GeneratorContext buildContext(AppPaths appPaths, IndexView index) {
        GeneratorContext context = GeneratorContext.ofResourcePath((File[])appPaths.getResourceFiles());
        context.withBuildContext((KogitoBuildContext)new QuarkusKogitoBuildContext(className -> {
            DotName classDotName = DotName.createSimple((String)className);
            return !index.getAnnotations(classDotName).isEmpty() || index.getClassByName(classDotName) != null;
        }));
        return context;
    }
}

