/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.base.ClassFieldAccessorFactory;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.internal.kogito.codegen.Generated;
import org.kie.internal.kogito.codegen.VariableInfo;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.quarkus.deployment.JandexProtoGenerator;
import org.kie.kogito.quarkus.deployment.KogitoCompilationProvider;

public class KogitoAssetsProcessor {
    private final transient String generatedClassesDir = System.getProperty("quarkus.debug.generated-classes-dir");
    private final transient String appPackageName = "org.kie.kogito.app";
    private final transient String persistenceFactoryClass = "org.kie.kogito.persistence.KogitoProcessInstancesFactory";
    private final transient String metricsClass = "org.kie.kogito.monitoring.rest.MetricsResource";

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.kogito");
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito");
    }

    public void generatePersistenceInfo(ArchiveRootBuildItem root, BuildProducer<GeneratedBeanBuildItem> generatedBeans, IndexView index, LaunchModeBuildItem launchMode, BuildProducer<NativeImageResourceBuildItem> resource, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException, BootstrapDependencyProcessingException {
        Path projectPath = this.getProjectPath(root.getArchiveLocation());
        ClassInfo persistenceClass = index.getClassByName(this.createDotName("org.kie.kogito.persistence.KogitoProcessInstancesFactory"));
        boolean usePersistence = persistenceClass != null;
        List<Object> parameters = new ArrayList();
        if (usePersistence) {
            for (MethodInfo mi : persistenceClass.methods()) {
                if (!mi.name().equals("<init>") || mi.parameters().isEmpty()) continue;
                parameters = mi.parameters().stream().map(p -> p.name().toString()).collect(Collectors.toList());
                break;
            }
        }
        Collection modelClasses = index.getAllKnownImplementors(this.createDotName(Model.class.getCanonicalName()));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(new File(projectPath.toFile(), "target"), modelClasses, usePersistence, (ProtoGenerator)new JandexProtoGenerator(index, this.createDotName(Generated.class.getCanonicalName()), this.createDotName(VariableInfo.class.getCanonicalName())), parameters);
        persistenceGenerator.setDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
        persistenceGenerator.setPackageName("org.kie.kogito.app");
        Collection generatedFiles = persistenceGenerator.generate();
        if (!generatedFiles.isEmpty()) {
            MemoryFileSystem trgMfs = new MemoryFileSystem();
            CompilationResult result = this.compile(root, trgMfs, curateOutcomeBuildItem.getEffectiveModel(), generatedFiles, launchMode.getLaunchMode(), root.getArchiveLocation());
            this.register(trgMfs, generatedBeans, (className, data) -> new GeneratedBeanBuildItem(className, data), launchMode.getLaunchMode(), result, root.getArchiveLocation());
        }
        if (usePersistence) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"kogito-types.proto"}));
        }
    }

    @BuildStep
    public List<ReflectiveHierarchyIgnoreWarningBuildItem> reflectiveDMNREST() {
        ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem> result = new ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem>();
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.api.builder.Message$Level")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNContext")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNDecisionResult")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNDecisionResult$DecisionEvaluationStatus")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessage")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessage$Severity")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessageType")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.feel.runtime.events.FEELEvent")));
        return result;
    }

    @BuildStep
    public RuntimeInitializedClassBuildItem runtimeInitializedClass() {
        return new RuntimeInitializedClassBuildItem(ClassFieldAccessorFactory.class.getName());
    }

    @BuildStep(loadsApplicationClasses=true)
    public void generateModel(ArchiveRootBuildItem root, BuildProducer<GeneratedBeanBuildItem> generatedBeans, CombinedIndexBuildItem combinedIndexBuildItem, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException, BootstrapDependencyProcessingException {
        if (liveReload.isLiveReload()) {
            return;
        }
        Path targetClassesPath = root.getArchiveLocation();
        Path projectPath = this.getProjectPath(targetClassesPath);
        ApplicationGenerator appGen = this.createApplicationGenerator(projectPath, launchMode.getLaunchMode(), combinedIndexBuildItem);
        Collection generatedFiles = appGen.generate();
        Collection javaFiles = generatedFiles.stream().filter(f -> f.relativePath().endsWith(".java")).collect(Collectors.toCollection(ArrayList::new));
        if (!javaFiles.isEmpty()) {
            Indexer kogitoIndexer = new Indexer();
            HashSet kogitoIndex = new HashSet();
            MemoryFileSystem trgMfs = new MemoryFileSystem();
            CompilationResult result = this.compile(root, trgMfs, curateOutcomeBuildItem.getEffectiveModel(), javaFiles, launchMode.getLaunchMode(), targetClassesPath);
            this.register(trgMfs, generatedBeans, (className, data) -> {
                IndexingUtil.indexClass((String)className, (Indexer)kogitoIndexer, (IndexView)combinedIndexBuildItem.getIndex(), (Set)kogitoIndex, (ClassLoader)Thread.currentThread().getContextClassLoader(), (byte[])data);
                return new GeneratedBeanBuildItem(className, data);
            }, launchMode.getLaunchMode(), result, targetClassesPath);
            Index index = kogitoIndexer.complete();
            this.generatePersistenceInfo(root, generatedBeans, (IndexView)CompositeIndex.create((IndexView[])new IndexView[]{combinedIndexBuildItem.getIndex(), index}), launchMode, resource, curateOutcomeBuildItem);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.AbstractProcessDataEvent"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.ProcessInstanceDataEvent"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessInstanceEventBody"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.NodeInstanceEventBody"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessErrorEventBody"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.UserTaskInstanceDataEvent"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.UserTaskInstanceEventBody"}));
            Collection dataEvents = index.getAllKnownSubclasses(this.createDotName("org.kie.kogito.services.event.AbstractProcessDataEvent"));
            dataEvents.forEach(c -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.name().toString()})));
        }
    }

    private Path getProjectPath(Path archiveLocation) {
        String path = archiveLocation.toString();
        if (path.endsWith("target" + File.separator + "classes")) {
            return archiveLocation.getParent().getParent();
        }
        if (path.endsWith(".jar") && archiveLocation.getParent().getFileName().toString().equals("target")) {
            return archiveLocation.getParent().getParent();
        }
        return archiveLocation;
    }

    private CompilationResult compile(ArchiveRootBuildItem root, MemoryFileSystem trgMfs, AppModel appModel, Collection<GeneratedFile> generatedFiles, LaunchMode launchMode, Path projectPath) throws IOException, BootstrapDependencyProcessingException {
        JavaCompiler javaCompiler = JavaParserCompiler.getCompiler();
        JavaCompilerSettings compilerSettings = javaCompiler.createDefaultSettings();
        compilerSettings.addClasspath(root.getArchiveLocation().toString());
        if (appModel != null) {
            for (AppDependency i : appModel.getUserDependencies()) {
                compilerSettings.addClasspath(i.getArtifact().getPath().toAbsolutePath().toString());
            }
        }
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        String[] sources = new String[generatedFiles.size()];
        int index = 0;
        for (GeneratedFile entry : generatedFiles) {
            String generatedClassFile = entry.relativePath().replace("src/main/java/", "");
            String fileName = this.toRuntimeSource(this.toClassName(generatedClassFile));
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.contents());
            String location = this.generatedClassesDir;
            if (launchMode == LaunchMode.DEVELOPMENT) {
                location = Paths.get(projectPath.toString(), new String[0]).toString();
            }
            this.writeGeneratedFile(entry, location);
        }
        return javaCompiler.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, Thread.currentThread().getContextClassLoader(), compilerSettings);
    }

    private void register(MemoryFileSystem trgMfs, BuildProducer generatedBeans, BiFunction<String, byte[], ? extends BuildItem> bif, LaunchMode launchMode, CompilationResult result, Path projectPath) throws IOException {
        if (result.getErrors().length > 0) {
            StringBuilder errorInfo = new StringBuilder();
            Arrays.stream(result.getErrors()).forEach(cp -> errorInfo.append(cp.toString()));
            throw new IllegalStateException(errorInfo.toString());
        }
        for (String fileName : trgMfs.getFileNames()) {
            byte[] data = trgMfs.getBytes(fileName);
            String className = this.toClassName(fileName);
            generatedBeans.produce(bif.apply(className, data));
            if (launchMode != LaunchMode.DEVELOPMENT) continue;
            Path path = this.writeFile(Paths.get(projectPath.toString(), fileName).toString(), data);
            String sourceFile = path.toString().replaceFirst("\\.class", ".java");
            if (sourceFile.contains("$")) {
                sourceFile = sourceFile.substring(0, sourceFile.indexOf("$")) + ".java";
            }
            KogitoCompilationProvider.classToSource.put(path, Paths.get(sourceFile, new String[0]));
        }
    }

    private Path writeFile(String fileName, byte[] data) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.write(path, data, new OpenOption[0]);
        return path;
    }

    private ApplicationGenerator createApplicationGenerator(Path projectPath, LaunchMode launchMode, CombinedIndexBuildItem combinedIndexBuildItem) throws IOException {
        boolean usePersistence = combinedIndexBuildItem.getIndex().getClassByName(this.createDotName("org.kie.kogito.persistence.KogitoProcessInstancesFactory")) != null;
        GeneratorContext context = GeneratorContext.ofResourcePath((File)projectPath.resolve("src/main/resources").toFile());
        context.withBuildContext((KogitoBuildContext)new QuarkusKogitoBuildContext(className -> {
            DotName classDotName = this.createDotName((String)className);
            return !combinedIndexBuildItem.getIndex().getAnnotations(classDotName).isEmpty() || combinedIndexBuildItem.getIndex().getClassByName(classDotName) != null;
        }));
        ApplicationGenerator appGen = new ApplicationGenerator("org.kie.kogito.app", new File(projectPath.toFile(), "target")).withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator()).withPersistence(usePersistence).withMonitoring(combinedIndexBuildItem.getIndex().getClassByName(this.createDotName("org.kie.kogito.monitoring.rest.MetricsResource")) != null).withGeneratorContext(context);
        boolean isDirectory = projectPath.toFile().isDirectory();
        this.addProcessGenerator(projectPath, usePersistence, appGen, isDirectory);
        this.addRuleGenerator(projectPath, appGen, isDirectory);
        this.addDecisionGenerator(projectPath, appGen, isDirectory);
        return appGen;
    }

    private void addRuleGenerator(Path projectPath, ApplicationGenerator appGen, boolean isDirectory) throws IOException {
        Path moduleXmlPath = projectPath.resolve("src/main/resources").resolve("META-INF/kmodule.xml");
        KieModuleModel kieModuleModel = null;
        kieModuleModel = Files.exists(moduleXmlPath, new LinkOption[0]) ? KieModuleModelImpl.fromXML((InputStream)new ByteArrayInputStream(Files.readAllBytes(moduleXmlPath))) : KieModuleModelImpl.fromXML((String)"<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>");
        IncrementalRuleCodegen generator = isDirectory ? IncrementalRuleCodegen.ofPath((Path)projectPath.resolve("src")) : IncrementalRuleCodegen.ofJar((Path)projectPath);
        ((IncrementalRuleCodegen)appGen.withGenerator((Generator)generator)).withKModule(kieModuleModel).withClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private void addProcessGenerator(Path projectPath, boolean usePersistence, ApplicationGenerator appGen, boolean isDirectory) throws IOException {
        ProcessCodegen generator = isDirectory ? ProcessCodegen.ofPath((Path)projectPath) : ProcessCodegen.ofJar((Path)projectPath);
        ((ProcessCodegen)appGen.withGenerator((Generator)generator)).withPersistence(usePersistence).withClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private void addDecisionGenerator(Path projectPath, ApplicationGenerator appGen, boolean isDirectory) throws IOException {
        DecisionCodegen generator = isDirectory ? DecisionCodegen.ofPath((Path)projectPath.resolve("src/main/resources")) : DecisionCodegen.ofJar((Path)projectPath);
        appGen.withGenerator((Generator)generator);
    }

    private String toRuntimeSource(String className) {
        return "src/main/java/" + className.replace('.', '/') + ".java";
    }

    private String toClassName(String sourceName) {
        if (sourceName.startsWith("./")) {
            sourceName = sourceName.substring(2);
        }
        if (sourceName.endsWith(".java")) {
            sourceName = sourceName.substring(0, sourceName.length() - 5);
        } else if (sourceName.endsWith(".class")) {
            sourceName = sourceName.substring(0, sourceName.length() - 6);
        }
        return sourceName.replace('/', '.');
    }

    private void writeGeneratedFile(GeneratedFile f, String location) throws IOException {
        if (location == null) {
            return;
        }
        String generatedClassFile = f.relativePath().replace("src/main/java", "");
        Files.write(this.pathOf(location, generatedClassFile), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(String location, String end) {
        Path path = Paths.get(location, end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    private DotName createDotName(String name) {
        int lastDot = name.indexOf(46);
        if (lastDot < 0) {
            return DotName.createComponentized(null, (String)name);
        }
        DotName lastDotName = null;
        while (lastDot > 0) {
            String local = name.substring(0, lastDot);
            name = name.substring(lastDot + 1);
            lastDot = name.indexOf(46);
            lastDotName = DotName.createComponentized(lastDotName, (String)local);
        }
        int lastDollar = name.indexOf(36);
        if (lastDollar < 0) {
            return DotName.createComponentized(lastDotName, (String)name);
        }
        DotName lastDollarName = null;
        while (lastDollar > 0) {
            String local = name.substring(0, lastDollar);
            name = name.substring(lastDollar + 1);
            lastDollar = name.indexOf(36);
            if (lastDollarName == null) {
                lastDollarName = DotName.createComponentized((DotName)lastDotName, (String)local);
                continue;
            }
            lastDollarName = DotName.createComponentized((DotName)lastDollarName, (String)local, (boolean)true);
        }
        return DotName.createComponentized(lastDollarName, (String)name, (boolean)true);
    }
}

