/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.JavaCompilationProvider;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.quarkus.deployment.KogitoCompilerException;

public abstract class KogitoCompilationProvider
extends JavaCompilationProvider {
    protected static Map<Path, Path> classToSource = new HashMap<Path, Path>();
    private String appPackageName = System.getProperty("kogito.codegen.packageName", "org.kie.kogito.app");

    public Set<String> handledSourcePaths() {
        return Collections.singleton("src" + File.separator + "main" + File.separator + "resources");
    }

    public final void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        URLClassLoader cl = new URLClassLoader(this.getClasspathUrls(context), null);
        File outputDirectory = context.getOutputDirectory();
        try {
            GeneratorContext generationContext = GeneratorContext.ofResourcePath((File[])new File[]{context.getProjectDirectory().toPath().resolve("src/main/resources").toFile()});
            generationContext.withBuildContext((KogitoBuildContext)new QuarkusKogitoBuildContext(className -> this.hasClassOnClasspath(cl, (String)className)));
            ApplicationGenerator appGen = new ApplicationGenerator(generationContext, this.appPackageName, outputDirectory);
            this.addGenerator(appGen, filesToCompile, context, cl);
            Collection generatedFiles = appGen.generate();
            HashSet<File> generatedSourceFiles = new HashSet<File>();
            for (GeneratedFile file : generatedFiles) {
                Path path = KogitoCompilationProvider.pathOf(outputDirectory.getPath(), file.relativePath());
                if (file.getType() == GeneratedFile.Type.APPLICATION || file.getType() == GeneratedFile.Type.APPLICATION_CONFIG) continue;
                Files.write(path, file.contents(), new OpenOption[0]);
                if (file.getType() == GeneratedFile.Type.RESOURCE || file.getType() == GeneratedFile.Type.GENERATED_CP_RESOURCE) continue;
                generatedSourceFiles.add(path.toFile());
            }
            super.compile(generatedSourceFiles, context);
        }
        catch (Exception e) {
            throw new KogitoCompilerException(e);
        }
        finally {
            try {
                cl.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Path getSourcePath(Path classFilePath, Set<String> sourcePaths, String classesPath) {
        if (classToSource.containsKey(classFilePath)) {
            return classToSource.get(classFilePath);
        }
        return null;
    }

    protected abstract Generator addGenerator(ApplicationGenerator var1, Set<File> var2, CompilationProvider.Context var3, ClassLoader var4) throws IOException;

    static Path pathOf(String path, String relativePath) {
        Path p = Paths.get(path, relativePath);
        p.getParent().toFile().mkdirs();
        return p;
    }

    private boolean hasClassOnClasspath(ClassLoader cl, String className) {
        try {
            cl.loadClass(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private URL[] getClasspathUrls(CompilationProvider.Context context) {
        Set elements = context.getClasspath();
        URL[] urls = new URL[elements.size() + 1];
        try {
            urls[0] = context.getOutputDirectory().toURI().toURL();
            int i = 1;
            for (File artifact : elements) {
                urls[i++] = artifact.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return urls;
    }
}

