/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.JavaCompilationProvider;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.GeneratedFileType;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.utils.AppPaths;
import org.kie.kogito.quarkus.deployment.KogitoCompilerException;
import org.kie.kogito.quarkus.deployment.KogitoQuarkusContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KogitoCompilationProvider
extends JavaCompilationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoCompilationProvider.class);
    protected static Map<Path, Path> classToSource = new HashMap<Path, Path>();

    public Set<String> handledSourcePaths() {
        return Collections.singleton("src" + File.separator + "main" + File.separator + "resources");
    }

    public final void compile(Set<File> filesToCompile, CompilationProvider.Context quarkusContext) {
        URLClassLoader cl = new URLClassLoader(this.getClasspathUrls(quarkusContext), null);
        File outputDirectory = quarkusContext.getOutputDirectory();
        try {
            AppPaths appPaths = AppPaths.fromProjectDir((Path)quarkusContext.getProjectDirectory().toPath());
            KogitoBuildContext context = KogitoQuarkusContextProvider.context(appPaths, cl);
            ApplicationGenerator appGen = new ApplicationGenerator(context);
            appGen.registerGeneratorIfEnabled(this.getGenerator(context, filesToCompile, quarkusContext));
            Collection generatedFiles = appGen.generate();
            HashSet<File> generatedSourceFiles = new HashSet<File>();
            for (GeneratedFile file : generatedFiles) {
                Path path = KogitoCompilationProvider.pathOf(outputDirectory.getPath(), file.relativePath());
                if (file.type().canHotReload()) {
                    Files.write(path, file.contents(), new OpenOption[0]);
                    if (!file.category().equals((Object)GeneratedFileType.Category.SOURCE)) continue;
                    generatedSourceFiles.add(path.toFile());
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Skipping file because cannot hot reload: " + file);
            }
            super.compile(generatedSourceFiles, quarkusContext);
        }
        catch (Exception e) {
            throw new KogitoCompilerException(e);
        }
        finally {
            try {
                cl.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Path getSourcePath(Path classFilePath, Set<String> sourcePaths, String classesPath) {
        if (classToSource.containsKey(classFilePath)) {
            return classToSource.get(classFilePath);
        }
        return null;
    }

    protected abstract Generator getGenerator(KogitoBuildContext var1, Set<File> var2, CompilationProvider.Context var3);

    static Path pathOf(String path, String relativePath) {
        Path p = Paths.get(path, relativePath);
        p.getParent().toFile().mkdirs();
        return p;
    }

    private URL[] getClasspathUrls(CompilationProvider.Context context) {
        Set elements = context.getClasspath();
        URL[] urls = new URL[elements.size() + 1];
        try {
            urls[0] = context.getOutputDirectory().toURI().toURL();
            int i = 1;
            for (File artifact : elements) {
                urls[i++] = artifact.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return urls;
    }
}

