/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.deployment.dev.CompilationProvider;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.io.CollectedResource;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.quarkus.deployment.KogitoCompilationProvider;
import org.kie.kogito.quarkus.deployment.PackageWalker;

public class RulesCompilationProvider
extends KogitoCompilationProvider {
    private static final Set<String> MANAGED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".drl", ".xls", ".xlsx", ".csv")));

    public Set<String> handledExtensions() {
        return MANAGED_EXTENSIONS;
    }

    @Override
    protected Generator getGenerator(KogitoBuildContext context, Set<File> filesToCompile, CompilationProvider.Context quarkusContext) {
        Path resources = quarkusContext.getProjectDirectory().toPath().resolve("src").resolve("main").resolve("resources");
        List<File> files = PackageWalker.getAllSiblings(filesToCompile);
        return IncrementalRuleCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResource.fromFiles((Path)resources, (File[])files.toArray(new File[0]))).withHotReloadMode();
    }
}

