/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.kie.kogito.Model;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.AppPaths;
import org.kie.kogito.codegen.core.utils.GeneratedFileValidation;
import org.kie.kogito.codegen.json.JsonSchemaGenerator;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.quarkus.common.deployment.InMemoryClassLoader;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedClassesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;
import org.kie.kogito.quarkus.processes.deployment.JandexProtoGenerator;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoProcessInstanceProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoTypesProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoWorkItemsProtobuf;

public class ProcessesAssetsProcessor {
    private static final DotName persistenceFactoryClass = DotName.createSimple((String)"org.kie.kogito.persistence.KogitoProcessInstancesFactory");
    private static final String PROCESS_SVG_SERVICE = "org.kie.kogito.svg.service.QuarkusProcessSvgService";
    private static final PathMatcher svgFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.svg");
    @Inject
    ArchiveRootBuildItem root;
    @Inject
    LiveReloadBuildItem liveReload;
    @Inject
    CurateOutcomeBuildItem curateOutcomeBuildItem;

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito-processes");
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void addProtoDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServiceProviderBuildItem> serviceProviderBuildItemBuildProducer) {
        KogitoBuildContext context = KogitoQuarkusResourceUtils.kogitoBuildContext((Iterable)this.root.getPaths(), null, (AppArtifact)this.curateOutcomeBuildItem.getEffectiveModel().getAppArtifact());
        if (context.getAddonsConfig().usePersistence()) {
            indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.google.protobuf", "protobuf-java"));
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"kogito-types.proto"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.persistence.ProtostreamObjectMarshaller"}));
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/" + ObjectMarshallerStrategy.class.getName()}));
            serviceProviderBuildItemBuildProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ObjectMarshallerStrategy.class.getName()));
            this.addInnerClasses(KogitoProcessInstanceProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoTypesProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoNodeInstanceContentsProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoWorkItemsProtobuf.class, reflectiveHierarchyClass);
        }
    }

    @BuildStep
    public ReflectiveClassBuildItem reflectionProcess() {
        return new ReflectiveClassBuildItem(true, true, new String[]{"org.kogito.workitem.rest.bodybuilders.ParamsRestWorkItemHandlerBodyBuilder", "org.kie.kogito.process.impl.BaseWorkItem", "org.kie.kogito.event.Topic", "org.kie.kogito.event.CloudEventMeta", "org.kie.kogito.jobs.api.Job"});
    }

    @BuildStep
    public void postGenerationProcessing(List<KogitoGeneratedClassesBuildItem> generatedKogitoClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatterns, BuildProducer<GeneratedResourceBuildItem> genResBI, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, CombinedIndexBuildItem combinedIndexBuildItem) throws IOException {
        IndexView aggregatedIndex = KogitoQuarkusResourceUtils.generateAggregatedIndex((IndexView)combinedIndexBuildItem.getIndex(), generatedKogitoClasses);
        KogitoBuildContext context = KogitoQuarkusResourceUtils.kogitoBuildContext((Iterable)this.root.getPaths(), (IndexView)aggregatedIndex, (AppArtifact)this.curateOutcomeBuildItem.getEffectiveModel().getAppArtifact());
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>(this.generatePersistenceInfo(context, aggregatedIndex, generatedBeans, resourcePatterns, runTimeConfiguration, this.liveReload.isLiveReload()));
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (KogitoGeneratedClassesBuildItem generatedKogitoClass : generatedKogitoClasses) {
            classes.putAll(generatedKogitoClass.getGeneratedClasses());
        }
        generatedFiles.addAll(this.generateJsonSchema(context, aggregatedIndex, classes));
        KogitoQuarkusResourceUtils.dumpFilesToDisk((AppPaths)context.getAppPaths(), generatedFiles);
        KogitoQuarkusResourceUtils.registerResources(generatedFiles, resource, genResBI);
        this.registerProcessSVG(context, resource);
    }

    private Collection<GeneratedFile> generatePersistenceInfo(KogitoBuildContext context, IndexView index, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatterns, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, boolean useDebugSymbols) throws IOException {
        Collection<GeneratedFile> persistenceGeneratedFiles = this.getGeneratedPersistenceFiles(index, context, runTimeConfiguration, resourcePatterns);
        GeneratedFileValidation.validateGeneratedFileTypes(persistenceGeneratedFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.RESOURCE));
        List dependencies = this.curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        KogitoQuarkusResourceUtils.compileGeneratedSources((KogitoBuildContext)context, (List)dependencies, persistenceGeneratedFiles, (boolean)useDebugSymbols).forEach(arg_0 -> generatedBeans.produce(arg_0));
        return persistenceGeneratedFiles;
    }

    private Collection<GeneratedFile> getGeneratedPersistenceFiles(IndexView index, KogitoBuildContext context, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatterns) {
        ClassInfo persistenceClass = index.getClassByName(persistenceFactoryClass);
        Collection modelClasses = index.getAllKnownImplementors(DotName.createSimple((String)Model.class.getCanonicalName()));
        JandexProtoGenerator protoGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder(index).withPersistenceClass((Object)persistenceClass).build(modelClasses);
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator);
        if (persistenceGenerator.persistenceType().equals("postgresql") || persistenceGenerator.persistenceType().equals("jdbc")) {
            resourcePatterns.produce((BuildItem)new NativeImageResourcePatternsBuildItem.Builder().includeGlob("sql/*.sql").build());
        } else if (persistenceGenerator.persistenceType().equals("kafka")) {
            String processIds = protoGenerator.getProcessIds().stream().map(s -> "kogito.process." + s).collect(Collectors.joining(","));
            runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.kafka-streams.topics", processIds));
        }
        return persistenceGenerator.generate();
    }

    private void addInnerClasses(Class<?> superClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass) {
        DotName dotName = DotName.createSimple((String)superClass.getName());
        Type type = Type.create((DotName)dotName, (Type.Kind)Type.Kind.CLASS);
        reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(type).build());
        Arrays.asList(superClass.getDeclaredClasses()).forEach(c -> this.addInnerClasses((Class<?>)c, reflectiveHierarchyClass));
    }

    private void registerProcessSVG(KogitoBuildContext context, BuildProducer<NativeImageResourceBuildItem> resource) throws IOException {
        if (!context.hasClassAvailable(PROCESS_SVG_SERVICE)) {
            return;
        }
        Path relativePath = Paths.get("META-INF", "processSVG");
        Path targetClasses = KogitoQuarkusResourceUtils.getTargetClassesPath((AppPaths)context.getAppPaths());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"org/apache/batik/util/resources/XMLResourceDescriptor.properties"}));
        Path resolvedPath = targetClasses.resolve(relativePath);
        try (Stream<Path> filePathFound = Files.find(resolvedPath, Integer.MAX_VALUE, (filePath, attrs) -> svgFileMatcher.matches((Path)filePath), new FileVisitOption[0]);){
            List svgs = filePathFound.map(svgPath -> targetClasses.relativize((Path)svgPath).toString()).collect(Collectors.toList());
            resource.produce((BuildItem)new NativeImageResourceBuildItem(svgs));
        }
    }

    private Collection<GeneratedFile> generateJsonSchema(KogitoBuildContext context, IndexView index, Map<String, byte[]> generatedClasses) throws IOException {
        InMemoryClassLoader cl = new InMemoryClassLoader(context.getClassLoader(), generatedClasses);
        Collection annotations = index.getAnnotations(DotName.createSimple((String)UserTask.class.getCanonicalName()));
        Stream<Class> stream = annotations.stream().map(arg_0 -> this.lambda$generateJsonSchema$4((ClassLoader)cl, arg_0)).filter(Optional::isPresent).map(Optional::get);
        JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator.ClassBuilder(stream).withGenSchemaPredicate(x -> true).withSchemaVersion(System.getProperty("kogito.jsonSchema.version")).build();
        return jsonSchemaGenerator.generate();
    }

    private Optional<Class<?>> loadClassFromAnnotation(AnnotationInstance annotationInstance, ClassLoader classLoader) {
        try {
            return Optional.of(classLoader.loadClass(annotationInstance.target().asClass().name().toString()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private /* synthetic */ Optional lambda$generateJsonSchema$4(ClassLoader cl, AnnotationInstance ann) {
        return this.loadClassFromAnnotation(ann, cl);
    }
}

