/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.devservices;

import java.util.Collections;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class DataIndexInMemoryContainer
extends GenericContainer<DataIndexInMemoryContainer> {
    public static final int PORT = 8080;
    public static final String DEV_SERVICE_LABEL = "kogito-dev-service-data-index";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexInMemoryContainer.class);
    private final int port;
    private final boolean useSharedNetwork;
    private String hostName = null;

    public DataIndexInMemoryContainer(DockerImageName dockerImageName, int fixedExposedPort, String serviceName, boolean useSharedNetwork) {
        super(dockerImageName);
        this.port = fixedExposedPort;
        this.useSharedNetwork = useSharedNetwork;
        this.withPrivilegedMode(true);
        this.withNetwork(Network.SHARED);
        if (useSharedNetwork) {
            this.hostName = "data-index-" + Base58.randomString((int)5);
            this.setNetworkAliases(Collections.singletonList(this.hostName));
        } else {
            this.withExposedPorts(new Integer[]{8080});
        }
        if (serviceName != null) {
            this.withLabel(DEV_SERVICE_LABEL, serviceName);
        }
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.withImagePullPolicy("latest".equalsIgnoreCase(dockerImageName.getVersionPart()) ? PullPolicy.alwaysPull() : PullPolicy.defaultPolicy());
    }

    protected void configure() {
        super.configure();
        if (this.port > 0 && !this.useSharedNetwork) {
            this.addFixedExposedPort(this.port, 8080);
        }
    }

    public String getUrl() {
        return String.format("http://%s:%s", this.getHostToUse(), this.getPortToUse());
    }

    private String getHostToUse() {
        return this.useSharedNetwork ? this.hostName : this.getHost();
    }

    private int getPortToUse() {
        return this.useSharedNetwork ? 8080 : this.getMappedPort(8080);
    }
}

