/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.devservices;

import io.quarkus.devservices.common.ConfigureUtil;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.utility.DockerImageName;

public class DataIndexInMemoryContainer
extends GenericContainer<DataIndexInMemoryContainer> {
    public static final int PORT = 8080;
    public static final String DEV_SERVICE_LABEL = "kogito-dev-service-data-index";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexInMemoryContainer.class);
    private final int fixedExposedPort;
    private final boolean useSharedNetwork;
    private String hostName = null;

    public DataIndexInMemoryContainer(DockerImageName dockerImageName, int fixedExposedPort, String serviceName, boolean useSharedNetwork) {
        super(dockerImageName);
        this.fixedExposedPort = fixedExposedPort;
        this.useSharedNetwork = useSharedNetwork;
        if (serviceName != null) {
            this.withLabel(DEV_SERVICE_LABEL, serviceName);
        }
        this.withPrivilegedMode(true);
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.withImagePullPolicy("latest".equalsIgnoreCase(dockerImageName.getVersionPart()) ? PullPolicy.alwaysPull() : PullPolicy.defaultPolicy());
    }

    protected void configure() {
        super.configure();
        if (this.useSharedNetwork) {
            this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"data-index");
            return;
        }
        if (this.fixedExposedPort > 0) {
            this.addFixedExposedPort(this.fixedExposedPort, 8080);
        } else {
            this.addExposedPorts(new int[]{8080});
        }
    }

    public String getUrl() {
        return String.format("http://%s:%s", this.getHostToUse(), this.getPortToUse());
    }

    private String getHostToUse() {
        return this.useSharedNetwork ? this.hostName : this.getHost();
    }

    private int getPortToUse() {
        return this.useSharedNetwork ? 8080 : this.getMappedPort(8080);
    }
}

