/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.devservices;

import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DataIndexEventPublisher
implements EventPublisher {
    public static final String KOGITO_DATA_INDEX = "kogito.data-index.url";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexEventPublisher.class);
    @ConfigProperty(name="kogito.data-index.url")
    String dataIndexUrl;
    @Inject
    Vertx vertx;
    WebClient webClient;

    @PostConstruct
    public void init() {
        this.webClient = WebClient.create((Vertx)this.vertx);
    }

    public void publish(DataEvent<?> event) {
        LOGGER.debug("Sending event to data index: {}", event);
        switch (event.getType()) {
            case "ProcessInstanceEvent": {
                this.webClient.postAbs(this.dataIndexUrl + "/processes").expect(ResponsePredicate.SC_ACCEPTED).sendJson(event, result -> {
                    if (result.failed()) {
                        LOGGER.error("Failed to send message to Data Index", result.cause());
                    } else {
                        LOGGER.debug("Event published to Data Index");
                    }
                });
                break;
            }
            case "UserTaskInstanceEvent": {
                this.webClient.postAbs(this.dataIndexUrl + "/tasks").expect(ResponsePredicate.SC_ACCEPTED).sendJson(event, result -> {
                    if (result.failed()) {
                        LOGGER.error("Failed to send message to Data Index", result.cause());
                    } else {
                        LOGGER.debug("Event published to Data Index");
                    }
                });
                break;
            }
            default: {
                LOGGER.debug("Unknown type of event '{}', ignoring for this publisher", (Object)event.getType());
            }
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        events.forEach(this::publish);
    }
}

