/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.process.incubation.quarkus.support;

import java.util.Map;
import org.kie.kogito.Model;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.Id;
import org.kie.kogito.incubation.common.LocalUri;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.objectmapper.InternalObjectMapper;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.services.StraightThroughProcessService;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;

class StraightThroughProcessServiceImpl
implements StraightThroughProcessService {
    private final Processes processes;

    StraightThroughProcessServiceImpl(Processes processes) {
        this.processes = processes;
    }

    public DataContext evaluate(Id processId, DataContext inputContext) {
        LocalUri processPath = processId.toLocalId().asLocalUri();
        if (processPath.startsWith("processes")) {
            LocalProcessId pid = (LocalProcessId)processId;
            Process process = this.processes.processById(pid.processId());
            MapDataContext mdc = (MapDataContext)inputContext.as(MapDataContext.class);
            Class<?> modelType = ((Model)process.createModel()).getClass();
            Model model = (Model)InternalObjectMapper.objectMapper().convertValue((Object)mdc, modelType);
            ProcessInstance instance = process.createInstance(model);
            instance.start();
            Map map = ((Model)instance.variables()).toMap();
            return MapDataContext.of((Map)map);
        }
        throw new IllegalArgumentException("Not a valid processId " + processPath);
    }
}

