/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.rules.incubation.quarkus.support;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.kogito.core.rules.incubation.quarkus.support.RuleUnitDataObjectMapper;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.Id;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.rules.QueryId;
import org.kie.kogito.incubation.rules.RuleUnitId;
import org.kie.kogito.incubation.rules.services.RuleUnitService;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.RuleUnits;

@ApplicationScoped
public class QuarkusRuleUnitService
implements RuleUnitService {
    @Inject
    Instance<RuleUnits> ruleUnits;
    @Inject
    RuleUnitDataObjectMapper mapper;

    public Stream<DataContext> evaluate(Id id, DataContext inputContext) {
        if (!(id instanceof QueryId)) {
            throw new IllegalArgumentException("Not a valid query id " + id.toLocalId());
        }
        QueryId queryId = (QueryId)id;
        RuleUnitId ruleUnitId = queryId.ruleUnitId();
        Map payload = ((MapDataContext)inputContext.as(MapDataContext.class)).toMap();
        RuleUnitData ruleUnitData = this.mapper.convertValue(payload, ruleUnitId);
        RuleUnit ruleUnit = ((RuleUnits)this.ruleUnits.get()).create(ruleUnitData.getClass());
        RuleUnitInstance instance = ruleUnit.createInstance(ruleUnitData);
        List results = instance.executeQuery(queryId.queryId());
        return results.stream().map(MapDataContext::of);
    }
}

