/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.process.ProcessContainerGenerator;
import org.kie.kogito.codegen.process.ProcessGenerator;
import org.kie.kogito.event.process.NodeInstanceEventBody;
import org.kie.kogito.event.process.ProcessDataEvent;
import org.kie.kogito.event.process.ProcessErrorEventBody;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceEventBody;
import org.kie.kogito.event.process.VariableInstanceDataEvent;
import org.kie.kogito.event.process.VariableInstanceEventBody;
import org.kie.kogito.process.expr.ExpressionHandler;
import org.kie.kogito.quarkus.common.deployment.KogitoAddonsPreGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;
import org.kie.kogito.quarkus.common.deployment.LiveReloadExecutionBuildItem;
import org.kie.kogito.quarkus.extensions.spi.deployment.KogitoProcessContainerGeneratorBuildItem;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowHandlerGeneratedFile;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowHandlerGenerator;
import org.kie.kogito.quarkus.serverless.workflow.openapi.ServerlessWorkflowOASFilter;
import org.kie.kogito.quarkus.serverless.workflow.openapi.WorkflowOpenApiHandlerGenerator;
import org.kie.kogito.quarkus.serverless.workflow.rpc.WorkflowRPCHandlerGenerator;
import org.kie.kogito.quarkus.workflow.deployment.WorkflowProcessor;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationIdFactory;
import org.kie.kogito.serverless.workflow.parser.FunctionNamespace;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandler;
import org.kie.kogito.serverless.workflow.parser.schema.OpenApiModelSchemaGenerator;

public class ServerlessWorkflowAssetsProcessor
extends WorkflowProcessor {
    private static WorkflowHandlerGenerator[] generators = new WorkflowHandlerGenerator[]{WorkflowOpenApiHandlerGenerator.instance, WorkflowRPCHandlerGenerator.instance};

    @BuildStep
    public FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito-serverless-workflow");
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageResourceBuildItem addExpressionHandlers(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ExpressionHandler.class.getCanonicalName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)FunctionNamespace.class.getCanonicalName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)FunctionTypeHandler.class.getCanonicalName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)WorkflowOperationIdFactory.class.getCanonicalName()));
        return new NativeImageResourceBuildItem(new String[]{"protobuf/descriptor-sets/output.protobin"});
    }

    @BuildStep
    void addWorkItemHandlers(KogitoBuildContextBuildItem contextBI, LiveReloadExecutionBuildItem liveReloadExecutionBuildItem, BuildProducer<KogitoAddonsPreGeneratedSourcesBuildItem> sources) {
        KogitoBuildContext context = contextBI.getKogitoBuildContext();
        IndexView index = liveReloadExecutionBuildItem.getIndexView();
        ArrayList<WorkflowHandlerGeneratedFile> generatedFiles = new ArrayList<WorkflowHandlerGeneratedFile>();
        for (WorkflowHandlerGenerator generator : generators) {
            for (WorkflowHandlerGeneratedFile generated : generator.generateHandlerClasses(context, index)) {
                generatedFiles.add(generated);
                context.addGeneratedHandler(generated.getWorkItemHandlerName());
            }
        }
        sources.produce((BuildItem)new KogitoAddonsPreGeneratedSourcesBuildItem(generatedFiles));
    }

    @BuildStep
    void addOpenAPIModelSchema(List<KogitoProcessContainerGeneratorBuildItem> processBuildItem, BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer) {
        HashMap<String, Schema> schemasInfo = new HashMap<String, Schema>();
        processBuildItem.stream().flatMap(it -> it.getProcessContainerGenerators().stream()).map(ProcessContainerGenerator::getProcesses).flatMap(Collection::stream).map(ProcessGenerator::getProcess).forEach(process -> OpenApiModelSchemaGenerator.addOpenAPIModelSchema(process, schemasInfo));
        if (!schemasInfo.isEmpty()) {
            openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)new ServerlessWorkflowOASFilter(schemasInfo)));
        }
    }

    @BuildStep
    public ReflectiveClassBuildItem eventsApiReflection() {
        return new ReflectiveClassBuildItem(true, true, new String[]{NodeInstanceEventBody.class.getName(), ProcessDataEvent.class.getName(), ProcessErrorEventBody.class.getName(), ProcessInstanceDataEvent.class.getName(), ProcessInstanceEventBody.class.getName(), VariableInstanceDataEvent.class.getName(), VariableInstanceEventBody.class.getName()});
    }

    @BuildStep
    IndexDependencyBuildItem addJsonSchemaValidatorToIndex() {
        return new IndexDependencyBuildItem("com.networknt", "json-schema-validator");
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void registerJsonValidatorSubclassesForReflection(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        combinedIndexBuildItem.getComputingIndex().getAllKnownImplementors(DotName.createSimple((String)"com.networknt.schema.JsonValidator")).forEach(c -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.name().toString()})));
    }
}

