/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.openapi;

import io.quarkiverse.openapi.generator.deployment.codegen.OpenApiSpecInputProvider;
import io.quarkiverse.openapi.generator.deployment.codegen.SpecInputModel;
import io.quarkus.deployment.CodeGenContext;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowCodeGenUtils;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowOperationResource;
import org.kie.kogito.serverless.workflow.utils.OpenAPIWorkflowUtils;

public class WorkflowOpenApiSpecInputProvider
implements OpenApiSpecInputProvider {
    private static final String KOGITO_PACKAGE_PREFIX = "org.kie.kogito.openapi.";

    public List<SpecInputModel> read(CodeGenContext context) {
        List<SpecInputModel> list;
        block9: {
            Path inputDir = context.inputDir();
            while (!Files.exists(inputDir, new LinkOption[0])) {
                inputDir = inputDir.getParent();
            }
            Stream<Path> openApiFilesPaths = Files.walk(inputDir, new FileVisitOption[0]);
            try {
                list = WorkflowCodeGenUtils.operationResources(openApiFilesPaths, OpenAPIWorkflowUtils::isOpenApiOperation, context).map(this::getSpecInput).collect(Collectors.toList());
                if (openApiFilesPaths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (openApiFilesPaths != null) {
                        try {
                            openApiFilesPaths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new IllegalStateException(io);
                }
            }
            openApiFilesPaths.close();
        }
        return list;
    }

    private SpecInputModel getSpecInput(WorkflowOperationResource resource) {
        return new SpecInputModel(resource.getOperationId().getFileName(), resource.getContentLoader().getInputStream(), KOGITO_PACKAGE_PREFIX + resource.getOperationId().getPackageName());
    }
}

