/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.rpc;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import io.grpc.Channel;
import io.quarkus.grpc.GrpcClient;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.IndexView;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowCodeGenUtils;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowHandlerGeneratedFile;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowHandlerGenerator;
import org.kie.kogito.serverless.workflow.rpc.FileDescriptorHolder;
import org.kie.kogito.serverless.workflow.rpc.RPCWorkItemHandler;
import org.kie.kogito.serverless.workflow.utils.RPCWorkflowUtils;

public class WorkflowRPCHandlerGenerator
implements WorkflowHandlerGenerator {
    public static final WorkflowRPCHandlerGenerator instance = new WorkflowRPCHandlerGenerator();

    private WorkflowRPCHandlerGenerator() {
    }

    private WorkflowHandlerGeneratedFile generateHandler(KogitoBuildContext context, String serviceName) {
        String packageName = context.getPackageName();
        String className = RPCWorkflowUtils.getRPCClassName((String)serviceName);
        CompilationUnit unit = new CompilationUnit(packageName);
        ClassOrInterfaceDeclaration clazz = unit.addClass(className);
        clazz.addExtendedType(StaticJavaParser.parseClassOrInterfaceType((String)RPCWorkItemHandler.class.getCanonicalName()));
        clazz.addAnnotation(ApplicationScoped.class);
        clazz.addField(Channel.class, serviceName, new Modifier.Keyword[0]).addAndGetAnnotation(GrpcClient.class);
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)clazz.addMethod("getChannel", new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).addParameter(String.class, "file")).addParameter(String.class, "service")).addAnnotation(Override.class)).setType(Channel.class)).setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ReturnStmt((Expression)new NameExpr(serviceName))})));
        clazz.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        ConstructorDeclaration constructor = clazz.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        constructor.addAnnotation(Inject.class);
        this.addAnnotation(constructor, Boolean.TYPE, "enumDefault", "kogito.grpc.enum.includeDefault", Boolean.toString(false));
        this.addAnnotation(constructor, Integer.TYPE, "streamTimeout", "kogito.grpc.stream.timeout", Integer.toString(20));
        constructor.setBody((BlockStmt)new BlockStmt().addStatement((Expression)((MethodCallExpr)new MethodCallExpr(null, "super").addArgument("enumDefault")).addArgument("streamTimeout")));
        clazz.addMethod("getName", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType((Type)StaticJavaParser.parseClassOrInterfaceType((String)String.class.getCanonicalName())).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)new StringLiteralExpr(className))));
        return WorkflowCodeGenUtils.fromCompilationUnit(className, context, unit, className);
    }

    @Override
    public Collection<WorkflowHandlerGeneratedFile> generateHandlerClasses(KogitoBuildContext context, IndexView index) {
        return FileDescriptorHolder.get().descriptor().map(fd -> fd.getFileList().stream().map(f -> f.getServiceList().stream()).flatMap(x -> x).map(s -> this.generateHandler(context, s.getName())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private void addAnnotation(ConstructorDeclaration constructor, Class<?> clazz, String paramName, String propertyName, String defaultValue) {
        constructor.addAndGetParameter(clazz, paramName).addAndGetAnnotation(ConfigProperty.class).addPair("name", (Expression)new StringLiteralExpr(propertyName)).addPair("defaultValue", (Expression)new StringLiteralExpr(defaultValue));
    }
}

