/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.schema;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.kie.kogito.serverless.workflow.parser.schema.RefSchemas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JsonSchemaImpl
extends SchemaImpl {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaImpl.class);

    @JsonSetter(value="$id")
    public void setId(String id) {
        RefSchemas.baseURI(id);
    }

    @JsonSetter(value="$ref")
    public void setRef(String ref) {
        if (ref != null && !((String)ref).startsWith("#")) {
            try (InputStream is = URIContentLoaderFactory.builder((URI)new URI((String)ref)).withBaseURI(RefSchemas.getBaseURI()).build().getInputStream();){
                String key;
                JsonSchemaImpl schema = (JsonSchemaImpl)((Object)ObjectMapperFactory.get().readValue(is.readAllBytes(), JsonSchemaImpl.class));
                if (schema.getTitle() == null) {
                    key = RefSchemas.getKey();
                    schema.title(key);
                } else {
                    key = schema.getTitle();
                }
                if (key != null) {
                    RefSchemas.get().put(key, (Schema)schema);
                }
                ref = "#/components/schemas/" + key;
            }
            catch (IOException | URISyntaxException e) {
                logger.info("Error loading ref {}", ref, (Object)e);
            }
        }
        super.setRef((String)ref);
    }

    @JsonDeserialize(as=JsonSchemaImpl.class)
    public Schema getItems() {
        return super.getItems();
    }

    @JsonDeserialize(contentAs=JsonSchemaImpl.class)
    public List<Schema> getAllOf() {
        return super.getAllOf();
    }

    @JsonDeserialize(contentAs=JsonSchemaImpl.class)
    public List<Schema> getAnyOf() {
        return super.getAnyOf();
    }

    @JsonDeserialize(contentAs=JsonSchemaImpl.class)
    public List<Schema> getOneOf() {
        return super.getOneOf();
    }

    @JsonDeserialize(contentAs=JsonSchemaImpl.class)
    public Map<String, Schema> getProperties() {
        return super.getProperties();
    }

    @JsonDeserialize(as=JsonSchemaImpl.class)
    public Schema getAdditionalPropertiesSchema() {
        return super.getAdditionalPropertiesSchema();
    }

    @JsonDeserialize(as=JsonSchemaImpl.class)
    public Schema getNot() {
        return super.getNot();
    }
}

