/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.asyncapi;

import com.asyncapi.v2._6_0.model.AsyncAPI;
import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import com.asyncapi.v2._6_0.model.channel.operation.Operation;
import io.quarkiverse.asyncapi.config.AsyncAPIRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.serverless.workflow.asyncapi.AsyncChannelInfo;
import org.kie.kogito.serverless.workflow.asyncapi.AsyncInfo;
import org.kie.kogito.serverless.workflow.asyncapi.AsyncInfoConverter;

public class AsyncAPIInfoConverter
implements AsyncInfoConverter {
    private final AsyncAPIRegistry registry;

    public AsyncAPIInfoConverter(AsyncAPIRegistry registry) {
        this.registry = registry;
    }

    public Optional<AsyncInfo> apply(String id) {
        return this.registry.getAsyncAPI(id).map(AsyncAPIInfoConverter::from);
    }

    private static AsyncInfo from(AsyncAPI asyncApi) {
        HashMap<String, AsyncChannelInfo> map = new HashMap<String, AsyncChannelInfo>();
        for (Map.Entry entry : asyncApi.getChannels().entrySet()) {
            AsyncAPIInfoConverter.addChannel(map, ((ChannelItem)entry.getValue()).getPublish(), (String)entry.getKey() + "_out", true);
            AsyncAPIInfoConverter.addChannel(map, ((ChannelItem)entry.getValue()).getSubscribe(), (String)entry.getKey(), false);
        }
        return new AsyncInfo(map);
    }

    private static void addChannel(Map<String, AsyncChannelInfo> map, Operation operation, String channelName, boolean publish) {
        String operationId;
        if (operation != null && (operationId = operation.getOperationId()) != null) {
            map.putIfAbsent(operationId, new AsyncChannelInfo(channelName, publish));
        }
    }
}

