/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.jbpm.workflow.core.WorkflowModelValidator;
import org.jbpm.workflow.core.WorkflowProcess;
import org.kie.kogito.Model;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.models.JsonNodeModelInput;
import org.kie.kogito.serverless.workflow.models.JsonNodeModelOutput;
import org.kie.kogito.serverless.workflow.parser.schema.JsonSchemaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenApiModelSchemaGenerator {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiModelSchemaGenerator.class);
    private static final Schema ID_SCHEMA = OASFactory.createSchema().type(Schema.SchemaType.STRING).description("Process instance id");
    private static final String INPUT_SUFFIX = "_input";
    private static final String OUTPUT_SUFFIX = "_output";

    private OpenApiModelSchemaGenerator() {
    }

    public static void addOpenAPIModelSchema(KogitoWorkflowProcess workflow, Map<String, Schema> schemas, Map<String, Schema> defSchemas) {
        if (workflow instanceof WorkflowProcess) {
            WorkflowProcess workflowProcess = (WorkflowProcess)workflow;
            OpenApiModelSchemaGenerator.getSchema(workflowProcess.getInputValidator()).ifPresent(v -> {
                String key = OpenApiModelSchemaGenerator.getSchemaName(workflow.getId(), INPUT_SUFFIX);
                schemas.put(key, OpenApiModelSchemaGenerator.schemaTitle(key, v));
                OpenApiModelSchemaGenerator.addDefs(defSchemas, v);
            });
            OpenApiModelSchemaGenerator.getSchema(workflowProcess.getOutputValidator()).ifPresent(v -> {
                String key = OpenApiModelSchemaGenerator.getSchemaName(workflow.getId(), OUTPUT_SUFFIX);
                schemas.put(key, OpenApiModelSchemaGenerator.createOutputSchema(OpenApiModelSchemaGenerator.schemaTitle(key, v)));
                OpenApiModelSchemaGenerator.addDefs(defSchemas, v);
            });
        }
    }

    private static void addDefs(Map<String, Schema> schemas, Schema v) {
        Map<String, Schema> defs = ((JsonSchemaImpl)v).getDefs();
        if (defs != null) {
            schemas.putAll(defs);
        }
    }

    private static Schema schemaTitle(String key, Schema schema) {
        if (!OpenApiModelSchemaGenerator.useTitle()) {
            logger.debug("use schema title is disabled, using {} as title", (Object)key);
            schema.title(key);
        } else if (schema.getTitle() == null) {
            logger.warn("Title for schema {} is null, using {}", (Object)schema, (Object)key);
            schema.title(key);
        }
        return schema;
    }

    private static boolean useTitle() {
        return ConfigProvider.getConfig().getOptionalValue("kogito.sw.schema.use_title", Boolean.class).orElse(true);
    }

    private static Schema createOutputSchema(Schema schema) {
        return OASFactory.createSchema().addProperty("workflowdata", schema).addProperty("id", ID_SCHEMA).title(schema.getTitle());
    }

    public static void mergeSchemas(OpenAPI targetSchema, Map<String, Schema> schemas, Map<String, Schema> defsSchemas) {
        Components components = targetSchema.getComponents();
        if (components == null) {
            components = OASFactory.createComponents();
            targetSchema.setComponents(components);
        }
        for (Schema schema : schemas.values()) {
            components.addSchema(schema.getTitle(), schema);
        }
        defsSchemas.forEach((arg_0, arg_1) -> ((Components)components).addSchema(arg_0, arg_1));
        if (targetSchema.getPaths() != null && targetSchema.getPaths().getPathItems() != null) {
            for (PathItem pathItem : targetSchema.getPaths().getPathItems().values()) {
                OpenApiModelSchemaGenerator.processOperation(schemas, pathItem.getPOST());
                OpenApiModelSchemaGenerator.processOperation(schemas, pathItem.getPUT());
                OpenApiModelSchemaGenerator.processOperation(schemas, pathItem.getPATCH());
                OpenApiModelSchemaGenerator.processOperation(schemas, pathItem.getGET());
                OpenApiModelSchemaGenerator.processOperation(schemas, pathItem.getDELETE());
            }
        }
    }

    private static Optional<Schema> getSchema(Optional<WorkflowModelValidator> validator) {
        return validator.flatMap(v -> v.schema(JsonNode.class)).map(OpenApiModelSchemaGenerator::getSchema);
    }

    private static Schema getSchema(JsonNode jsonNode) {
        return (Schema)ObjectMapperFactory.get().convertValue((Object)jsonNode, JsonSchemaImpl.class);
    }

    private static String getSchemaName(String id, String suffix) {
        return id + suffix;
    }

    private static void processOperation(Map<String, Schema> schemas, Operation operation) {
        List tags;
        if (operation != null && (tags = operation.getTags()) != null) {
            for (String tag : tags) {
                Schema schema;
                if (operation.getRequestBody() != null && (schema = schemas.get(OpenApiModelSchemaGenerator.getSchemaName(tag, INPUT_SUFFIX))) != null) {
                    OpenApiModelSchemaGenerator.getMediaTypes(operation.getRequestBody().getContent()).stream().filter(OpenApiModelSchemaGenerator::isInput).forEach(mediaType -> mediaType.setSchema(schema));
                }
                if (operation.getResponses() == null || operation.getResponses().getAPIResponses() == null || (schema = schemas.get(OpenApiModelSchemaGenerator.getSchemaName(tag, OUTPUT_SUFFIX))) == null) continue;
                for (APIResponse response : operation.getResponses().getAPIResponses().values()) {
                    Content content = response.getContent();
                    if (content == null) {
                        response.setContent(OASFactory.createContent().addMediaType("application/json", OASFactory.createMediaType().schema(schema)));
                        continue;
                    }
                    OpenApiModelSchemaGenerator.getMediaTypes(content).stream().filter(OpenApiModelSchemaGenerator::isOutput).forEach(mediaType -> mediaType.setSchema(schema));
                }
            }
        }
    }

    private static boolean isOutput(MediaType type) {
        return OpenApiModelSchemaGenerator.isJsonModelRef(type, JsonNodeModelOutput.class);
    }

    private static boolean isInput(MediaType type) {
        return OpenApiModelSchemaGenerator.isJsonModelRef(type, JsonNodeModelInput.class);
    }

    private static boolean isJsonModelRef(MediaType type, Class<? extends Model> clazz) {
        Schema schema = type.getSchema();
        return schema != null && type.getSchema().getRef() != null && type.getSchema().getRef().endsWith(clazz.getSimpleName());
    }

    private static Collection<MediaType> getMediaTypes(Content content) {
        return content != null && content.getMediaTypes() != null ? content.getMediaTypes().values() : List.of();
    }
}

