"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobsManagementGatewayApiImpl = void 0;
var apis_1 = require("../apis");
var JobsManagementGatewayApiImpl = (function () {
    function JobsManagementGatewayApiImpl(queries) {
        var _this = this;
        this.initialLoad = function (filter, orderBy) {
            _this._JobsManagementState.filters = filter;
            _this._JobsManagementState.orderBy = orderBy;
            return Promise.resolve();
        };
        this.applyFilter = function (filter) {
            _this._JobsManagementState.filters = filter;
            return Promise.resolve();
        };
        this.cancelJob = function (job) {
            return (0, apis_1.jobCancel)(job);
        };
        this.rescheduleJob = function (job, repeatInterval, repeatLimit, scheduleDate) {
            return (0, apis_1.handleJobReschedule)(job, repeatInterval, repeatLimit, scheduleDate);
        };
        this.bulkCancel = function (jobsToBeActioned) {
            return (0, apis_1.performMultipleCancel)(jobsToBeActioned);
        };
        this.sortBy = function (orderBy) {
            _this._JobsManagementState.orderBy = orderBy;
            return Promise.resolve();
        };
        this.queries = queries;
        this._JobsManagementState = { filters: [], orderBy: {} };
    }
    Object.defineProperty(JobsManagementGatewayApiImpl.prototype, "jobsManagementState", {
        get: function () {
            return this._JobsManagementState;
        },
        enumerable: false,
        configurable: true
    });
    JobsManagementGatewayApiImpl.prototype.query = function (offset, limit) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.queries
                .getJobs(offset, limit, _this._JobsManagementState.filters, _this._JobsManagementState.orderBy)
                .then(function (value) {
                resolve(value);
            })
                .catch(function (reason) {
                reject(reason);
            });
        });
    };
    return JobsManagementGatewayApiImpl;
}());
exports.JobsManagementGatewayApiImpl = JobsManagementGatewayApiImpl;
//# sourceMappingURL=JobsManagementGatewayApi.js.map