"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var apollo_link_http_1 = require("apollo-link-http");
var apollo_link_error_1 = require("apollo-link-error");
var ServerUnavailablePage_1 = require("@kogito-apps/consoles-common/dist/components/pages/ServerUnavailablePage");
var apollo_cache_inmemory_1 = require("apollo-cache-inmemory");
var apollo_client_1 = __importDefault(require("apollo-client"));
var DevUIRoutes_1 = __importDefault(require("../DevUIRoutes/DevUIRoutes"));
var DevUILayout_1 = __importDefault(require("../DevUILayout/DevUILayout"));
var react_dom_1 = __importDefault(require("react-dom"));
var RuntimeTools = function (_a) {
    var users = _a.users, dataIndexUrl = _a.dataIndexUrl, trustyServiceUrl = _a.trustyServiceUrl, navigate = _a.navigate, devUIUrl = _a.devUIUrl, openApiPath = _a.openApiPath, isProcessEnabled = _a.isProcessEnabled, isTracingEnabled = _a.isTracingEnabled, availablePages = _a.availablePages, customLabels = _a.customLabels, omittedProcessTimelineEvents = _a.omittedProcessTimelineEvents, diagramPreviewSize = _a.diagramPreviewSize, isStunnerEnabled = _a.isStunnerEnabled;
    var httpLink = new apollo_link_http_1.HttpLink({
        uri: dataIndexUrl
    });
    var fallbackUI = (0, apollo_link_error_1.onError)(function (_a) {
        var networkError = _a.networkError;
        if (networkError && networkError.stack === 'TypeError: Failed to fetch') {
            return react_dom_1.default.render((0, jsx_runtime_1.jsx)(DevUILayout_1.default, __assign({ apolloClient: client, users: users, devUIUrl: devUIUrl, openApiPath: openApiPath, isProcessEnabled: isProcessEnabled, isTracingEnabled: isTracingEnabled, availablePages: availablePages, customLabels: customLabels, omittedProcessTimelineEvents: omittedProcessTimelineEvents, diagramPreviewSize: diagramPreviewSize, isStunnerEnabled: isStunnerEnabled }, { children: (0, jsx_runtime_1.jsx)(ServerUnavailablePage_1.ServerUnavailablePage, { displayName: 'Runtime Dev UI', reload: function () { return window.location.reload(); } }) })), document.getElementById('envelope-app'));
        }
    });
    var cache = new apollo_cache_inmemory_1.InMemoryCache();
    var client = new apollo_client_1.default({
        cache: cache,
        link: fallbackUI.concat(httpLink)
    });
    return ((0, jsx_runtime_1.jsx)(DevUILayout_1.default, __assign({ apolloClient: client, users: users, devUIUrl: devUIUrl, openApiPath: openApiPath, isProcessEnabled: isProcessEnabled, isTracingEnabled: isTracingEnabled, availablePages: availablePages, customLabels: customLabels, omittedProcessTimelineEvents: omittedProcessTimelineEvents, diagramPreviewSize: diagramPreviewSize, isStunnerEnabled: isStunnerEnabled }, { children: (0, jsx_runtime_1.jsx)(DevUIRoutes_1.default, { navigate: navigate, trustyServiceUrl: trustyServiceUrl, dataIndexUrl: dataIndexUrl }) })));
};
exports.default = RuntimeTools;
//# sourceMappingURL=RuntimeTools.js.map