"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useDevUIAppContext = exports.DevUIAppContextImpl = void 0;
var react_1 = __importStar(require("react"));
var DevUIAppContextImpl = (function () {
    function DevUIAppContextImpl(args) {
        var _a;
        this.args = args;
        this.userListeners = [];
        if (((_a = args.users) === null || _a === void 0 ? void 0 : _a.length) > 0) {
            this.currentUser = args.users[0];
        }
    }
    DevUIAppContextImpl.prototype.getDevUIUrl = function () {
        return this.args.devUIUrl;
    };
    DevUIAppContextImpl.prototype.getOpenApiPath = function () {
        return this.args.openApiPath;
    };
    DevUIAppContextImpl.prototype.getCurrentUser = function () {
        return this.currentUser;
    };
    DevUIAppContextImpl.prototype.getAllUsers = function () {
        return this.args.users;
    };
    DevUIAppContextImpl.prototype.switchUser = function (userId) {
        var switchedUser = this.args.users.find(function (user) { return user.id === userId; });
        if (switchedUser) {
            this.currentUser = switchedUser;
            this.userListeners.forEach(function (listener) {
                return listener.onUserChange(switchedUser);
            });
        }
    };
    DevUIAppContextImpl.prototype.onUserChange = function (listener) {
        var _this = this;
        this.userListeners.push(listener);
        return {
            unSubscribe: function () {
                var index = _this.userListeners.indexOf(listener);
                if (index > -1) {
                    _this.userListeners.splice(index, 1);
                }
            }
        };
    };
    DevUIAppContextImpl.prototype.isWorkflow = function () {
        var _a;
        return ((_a = this.args.customLabels) === null || _a === void 0 ? void 0 : _a.singularProcessLabel) == 'Workflow';
    };
    DevUIAppContextImpl.prototype.getIsStunnerEnabled = function () {
        return this.args.isStunnerEnabled;
    };
    Object.defineProperty(DevUIAppContextImpl.prototype, "isProcessEnabled", {
        get: function () {
            return this.args.isProcessEnabled;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DevUIAppContextImpl.prototype, "isTracingEnabled", {
        get: function () {
            return this.args.isTracingEnabled;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DevUIAppContextImpl.prototype, "isStunnerEnabled", {
        get: function () {
            return this.args.isStunnerEnabled;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DevUIAppContextImpl.prototype, "availablePages", {
        get: function () {
            return this.args.availablePages;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DevUIAppContextImpl.prototype, "customLabels", {
        get: function () {
            return this.args.customLabels;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DevUIAppContextImpl.prototype, "omittedProcessTimelineEvents", {
        get: function () {
            return this.args.omittedProcessTimelineEvents;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DevUIAppContextImpl.prototype, "diagramPreviewSize", {
        get: function () {
            return this.args.diagramPreviewSize;
        },
        enumerable: false,
        configurable: true
    });
    return DevUIAppContextImpl;
}());
exports.DevUIAppContextImpl = DevUIAppContextImpl;
var RuntimeToolsDevUIAppContext = react_1.default.createContext(null);
exports.default = RuntimeToolsDevUIAppContext;
var useDevUIAppContext = function () {
    return (0, react_1.useContext)(RuntimeToolsDevUIAppContext);
};
exports.useDevUIAppContext = useDevUIAppContext;
//# sourceMappingURL=DevUIAppContext.js.map