"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessListGatewayApiImpl = void 0;
var ProcessListGatewayApiImpl = (function () {
    function ProcessListGatewayApiImpl(queries) {
        var _this = this;
        this.onOpenProcessListeners = [];
        this.onOpenTriggerCloudEventListeners = [];
        this.openProcess = function (process) {
            _this.onOpenProcessListeners.forEach(function (listener) { return listener.onOpen(process); });
            return Promise.resolve();
        };
        this.initialLoad = function (filter, sortBy) {
            _this._ProcessListState.filters = filter;
            _this._ProcessListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.applyFilter = function (filter) {
            _this.processListState.filters = filter;
            return Promise.resolve();
        };
        this.applySorting = function (sortBy) {
            _this._ProcessListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.handleProcessSkip = function (processInstance) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.queries.handleProcessSkip(processInstance)];
            });
        }); };
        this.handleProcessRetry = function (processInstance) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.queries.handleProcessRetry(processInstance)];
            });
        }); };
        this.handleProcessAbort = function (processInstance) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.queries.handleProcessAbort(processInstance)];
            });
        }); };
        this.handleProcessMultipleAction = function (processInstances, operationType) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.queries.handleProcessMultipleAction(processInstances, operationType)];
            });
        }); };
        this.queries = queries;
        this._ProcessListState = {
            filters: {
                status: [],
                businessKey: []
            },
            sortBy: {}
        };
    }
    Object.defineProperty(ProcessListGatewayApiImpl.prototype, "processListState", {
        get: function () {
            return this._ProcessListState;
        },
        enumerable: false,
        configurable: true
    });
    ProcessListGatewayApiImpl.prototype.query = function (offset, limit) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.queries
                .getProcessInstances(offset, limit, _this._ProcessListState.filters, _this._ProcessListState.sortBy)
                .then(function (value) {
                resolve(value);
            })
                .catch(function (reason) {
                reject(reason);
            });
        });
    };
    ProcessListGatewayApiImpl.prototype.getChildProcessesQuery = function (rootProcessInstanceId) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.queries
                .getChildProcessInstances(rootProcessInstanceId)
                .then(function (value) {
                resolve(value);
            })
                .catch(function (reason) {
                reject(reason);
            });
        });
    };
    ProcessListGatewayApiImpl.prototype.onOpenProcessListen = function (listener) {
        var _this = this;
        this.onOpenProcessListeners.push(listener);
        var unSubscribe = function () {
            var index = _this.onOpenProcessListeners.indexOf(listener);
            if (index > -1) {
                _this.onOpenProcessListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe: unSubscribe
        };
    };
    ProcessListGatewayApiImpl.prototype.onOpenTriggerCloudEventListen = function (listener) {
        var _this = this;
        this.onOpenTriggerCloudEventListeners.push(listener);
        var unSubscribe = function () {
            var index = _this.onOpenTriggerCloudEventListeners.indexOf(listener);
            if (index > -1) {
                _this.onOpenTriggerCloudEventListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe: unSubscribe
        };
    };
    ProcessListGatewayApiImpl.prototype.openTriggerCloudEvent = function (processInstance) {
        this.onOpenTriggerCloudEventListeners.forEach(function (listener) {
            return listener.onOpen(processInstance);
        });
    };
    return ProcessListGatewayApiImpl;
}());
exports.ProcessListGatewayApiImpl = ProcessListGatewayApiImpl;
//# sourceMappingURL=ProcessListGatewayApi.js.map