"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var jobs_management_1 = require("@kogito-apps/jobs-management");
var JobsManagementContext_1 = require("../../../channel/JobsManagement/JobsManagementContext");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var JobsManagementContainer = function (_a) {
    var ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var gatewayApi = (0, JobsManagementContext_1.useJobsManagementGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    return ((0, jsx_runtime_1.jsx)(jobs_management_1.EmbeddedJobsManagement, __assign({ driver: gatewayApi, targetOrigin: appContext.getDevUIUrl() }, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'jobs-management-container', ouiaSafe))));
};
exports.default = JobsManagementContainer;
//# sourceMappingURL=JobsManagementContainer.js.map