"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.open = exports.createDevUI = void 0;
var iframe_html_1 = __importDefault(require("!!raw-loader!../../resources/iframe.html"));
var channel_1 = require("@kie-tools-core/envelope-bus/dist/channel");
var RuntimeToolsDevUIChannelApiImpl_1 = require("../standalone/RuntimeToolsDevUIChannelApiImpl");
var createEnvelopeServer = function (iframe, isDataIndexAvailable, isTracingEnabled, users, dataIndexUrl, trustyServiceUrl, page, devUIUrl, openApiPath, customLabels, isStunnerEnabled, diagramPreviewSize, origin, availablePages, omittedProcessTimelineEvents) {
    var defaultOrigin = window.location.protocol === 'file:' ? '*' : window.location.origin;
    return new channel_1.EnvelopeServer({
        postMessage: function (message) { var _a; return (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.postMessage(message, origin !== null && origin !== void 0 ? origin : defaultOrigin); }
    }, origin !== null && origin !== void 0 ? origin : defaultOrigin, function (self) {
        return self.envelopeApi.requests.runtimeToolsDevUI_initRequest({
            origin: self.origin,
            envelopeServerId: self.id
        }, {
            isDataIndexAvailable: isDataIndexAvailable,
            isTracingEnabled: isTracingEnabled,
            users: users,
            dataIndexUrl: dataIndexUrl,
            trustyServiceUrl: trustyServiceUrl,
            page: page,
            devUIUrl: devUIUrl,
            openApiPath: openApiPath,
            customLabels: customLabels,
            availablePages: availablePages,
            omittedProcessTimelineEvents: omittedProcessTimelineEvents,
            isStunnerEnabled: isStunnerEnabled,
            diagramPreviewSize: diagramPreviewSize
        });
    });
};
var createDevUI = function (envelopeServer, listener, iframe) {
    return {
        envelopeApi: envelopeServer.envelopeApi,
        close: function () {
            window.removeEventListener('message', listener);
            iframe.remove();
        }
    };
};
exports.createDevUI = createDevUI;
function open(args) {
    var _a, _b;
    var iframe = document.createElement('iframe');
    iframe.srcdoc = iframe_html_1.default;
    iframe.id = 'iframe';
    iframe.style.width = '100%';
    iframe.style.height = '100%';
    iframe.style.border = 'none';
    var envelopeServer = createEnvelopeServer(iframe, args.isDataIndexAvailable, args.isTracingEnabled, args.users, args.dataIndexUrl, args.trustyServiceUrl, args.page, args.devUIUrl, args.openApiPath, (_a = args.customLabels) !== null && _a !== void 0 ? _a : {
        singularProcessLabel: 'Process',
        pluralProcessLabel: 'Processes'
    }, args.isStunnerEnabled, args.diagramPreviewSize, args.origin, args.availablePages, (_b = args.omittedProcessTimelineEvents) !== null && _b !== void 0 ? _b : []);
    var channelApi = new RuntimeToolsDevUIChannelApiImpl_1.RuntimeToolsDevUIChannelApiImpl();
    var listener = function (message) {
        envelopeServer.receive(message.data, channelApi);
    };
    window.addEventListener('message', listener);
    args.container.appendChild(iframe);
    envelopeServer.startInitPolling(channelApi);
    return (0, exports.createDevUI)(envelopeServer, listener, iframe);
}
exports.open = open;
window.RuntimeToolsDevUI = { open: open };
//# sourceMappingURL=standalone.js.map