/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.swf.tools.custom.dashboard.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.kie.kogito.swf.tools.custom.dashboard.CustomDashboardStorage;
import org.kie.kogito.swf.tools.custom.dashboard.model.CustomDashboardFilter;
import org.kie.kogito.swf.tools.custom.dashboard.model.CustomDashboardInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CustomDashboardStorageImpl
implements CustomDashboardStorage {
    public static final String PROJECT_CUSTOM_DASHBOARD_STORAGE_PROP = "quarkus.kogito-runtime-tools.custom.dashboard.folder";
    private static final String CUSTOM_DASHBOARD_STORAGE_PATH = "/dashboards/";
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomDashboardStorageImpl.class);
    private final Map<String, CustomDashboardInfo> customDashboardInfoMap = new HashMap<String, CustomDashboardInfo>();
    private URL classLoaderCustomDashboardUrl;
    private URL customDashStorageUrl;

    public CustomDashboardStorageImpl() {
        this.start(Thread.currentThread().getContextClassLoader().getResource(CUSTOM_DASHBOARD_STORAGE_PATH));
    }

    public CustomDashboardStorageImpl(URL classLoaderFormsUrl) {
        this.start(classLoaderFormsUrl);
    }

    private void start(URL classLoaderFormsUrl) {
        this.start(classLoaderFormsUrl, this.getCustomDashboardStorageUrl(classLoaderFormsUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(URL classLoaderCustomDashboardUrl, URL customDashStorageUrl) {
        try {
            this.classLoaderCustomDashboardUrl = classLoaderCustomDashboardUrl;
            this.customDashStorageUrl = customDashStorageUrl;
        }
        catch (Exception ex) {
            LOGGER.warn("Couldn't properly initialize CustomDashboardStorageImpl");
        }
        finally {
            this.init();
        }
    }

    private URL getCustomDashboardStorageUrl(URL classLoaderCustomDashboardUrl) {
        if (classLoaderCustomDashboardUrl == null) {
            return null;
        }
        String storageUrl = ConfigProvider.getConfig().getOptionalValue(PROJECT_CUSTOM_DASHBOARD_STORAGE_PROP, String.class).orElseGet(() -> classLoaderCustomDashboardUrl.getFile());
        File customDashStorageeFolder = new File(storageUrl);
        if (!customDashStorageeFolder.exists() || !customDashStorageeFolder.isDirectory()) {
            LOGGER.warn("Cannot initialize form storage folder in path '" + customDashStorageeFolder.getPath() + "'");
        }
        try {
            return customDashStorageeFolder.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            LOGGER.warn("Cannot initialize form storage folder in path '" + customDashStorageeFolder.getPath() + "'", (Throwable)ex);
            return null;
        }
    }

    @Override
    public int getCustomDashboardFilesCount() {
        return this.customDashboardInfoMap.size();
    }

    @Override
    public Collection<CustomDashboardInfo> getCustomDashboardFiles(CustomDashboardFilter filter) {
        if (filter != null && !filter.getNames().isEmpty()) {
            return this.customDashboardInfoMap.entrySet().stream().filter(entry -> StringUtils.containsAnyIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence[])filter.getNames().toArray(new String[0]))).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        return this.customDashboardInfoMap.values();
    }

    @Override
    public String getCustomDashboardFileContent(String name) throws IOException {
        try {
            return IOUtils.toString((InputStream)new FileInputStream(this.customDashboardInfoMap.get(name).getPath()), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.info("custom-dashboard's file {} can not ready, because of {}", (Object)this.customDashboardInfoMap.get(name).getPath(), (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public void updateCustomDashboard(String content) {
    }

    private void init() {
        this.readCustomDashboardResources().stream().forEach(file -> {
            LocalDateTime lastModified = LocalDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), TimeZone.getDefault().toZoneId());
            this.customDashboardInfoMap.put(file.getName(), new CustomDashboardInfo(file.getName(), this.getRelativePath((File)file), lastModified));
        });
    }

    private Collection<File> readCustomDashboardResources() {
        if (this.classLoaderCustomDashboardUrl != null) {
            LOGGER.info("custom-dashboard's files path is {}", (Object)this.classLoaderCustomDashboardUrl.toString());
            File rootFolder = FileUtils.toFile((URL)this.classLoaderCustomDashboardUrl);
            return FileUtils.listFiles((File)rootFolder, (String[])new String[]{"dash.yaml"}, (boolean)false);
        }
        return Collections.emptyList();
    }

    private String getRelativePath(File file) {
        return this.classLoaderCustomDashboardUrl.getPath() + file.getName();
    }
}

