/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.swf.tools.dataindex;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.kie.kogito.swf.tools.dataindex.DataIndexClient;
import org.kie.kogito.swf.tools.dataindex.jobs.JobsResponse;
import org.kie.kogito.swf.tools.dataindex.workflows.WorkflowInstancesResponse;

@Path(value="/dataindex")
public class DataIndexService {
    public static final String ALL_WORKFLOW_INSTANCES_IDS_QUERY = "{ \"operationName\": \"getAllProcessesIds\", \"query\": \"query getAllProcessesIds{  ProcessInstances{ id } }\" }";
    public static final String ALL_JOBS_IDS_QUERY = "{ \"operationName\": \"getAllJobsIds\", \"query\": \"query getAllJobsIds{  Jobs{ id } }\" }";
    private final ObjectMapper mapper;
    private final DataIndexClient dataIndexClient;

    @Inject
    public DataIndexService(ObjectMapper mapper, @RestClient DataIndexClient dataIndexClient) {
        this.mapper = mapper;
        this.dataIndexClient = dataIndexClient;
    }

    @GET
    @Path(value="/workflowInstances/count")
    @Produces(value={"text/plain"})
    public Response workflowInstancesCount() {
        try {
            WorkflowInstancesResponse response = this.doQuery(ALL_WORKFLOW_INSTANCES_IDS_QUERY, WorkflowInstancesResponse.class);
            int workflowInstancesCount = response.getData().getWorkflowInstances().size();
            return Response.ok((Object)workflowInstancesCount).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/jobs/count")
    @Produces(value={"text/plain"})
    public Response jobsCount() {
        try {
            JobsResponse jobsResponse = this.doQuery(ALL_JOBS_IDS_QUERY, JobsResponse.class);
            int jobsCount = jobsResponse.getData().getJobs().size();
            return Response.ok((Object)jobsCount).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    private <T> T doQuery(String query, Class<T> type) throws JsonProcessingException {
        String response = this.dataIndexClient.query(query);
        return (T)this.mapper.readValue(response, type);
    }
}

