/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.swf.tools.custom.dashboard;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.kie.kogito.swf.tools.custom.dashboard.CustomDashboardStorage;
import org.kie.kogito.swf.tools.custom.dashboard.model.CustomDashboardFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/customDashboard")
public class CustomDashboardService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomDashboardService.class);
    private CustomDashboardStorage storage;

    @Inject
    public void setStorage(CustomDashboardStorage storage) {
        this.storage = storage;
    }

    @GET
    @Path(value="/count")
    @Produces(value={"text/plain"})
    public Response getCustomDashboardFilesCount() {
        try {
            return Response.ok((Object)this.storage.getCustomDashboardFilesCount()).build();
        }
        catch (Exception e) {
            LOGGER.warn("Error while getting CustomDashboard file count: ", (Throwable)e);
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)("Unexpected error while getting CustomDashboard files count: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response getCustomDashboardFiles(@QueryParam(value="names") CustomDashboardFilter filter) {
        try {
            return Response.ok(this.storage.getCustomDashboardFiles(filter)).build();
        }
        catch (Exception e) {
            LOGGER.warn("Error while getting CustomDashboard list: ", (Throwable)e);
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)("Unexpected error while getting CustomDashboard files list: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/{name:\\S+}")
    @Produces(value={"application/json"})
    public Response getCustomDashboardFileContent(@PathParam(value="name") String name) {
        try {
            return Response.ok((Object)this.storage.getCustomDashboardFileContent(name)).build();
        }
        catch (Exception e) {
            LOGGER.warn("Error while getting CustomDashboard file content: ", (Throwable)e);
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)("Unexpected error while getting CustomDashboard file content: " + e.getMessage())).build();
        }
    }
}

