/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import io.quarkus.arc.Arc;
import io.quarkus.security.identity.SecurityIdentity;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Function;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.serverless.workflow.utils.KogitoProcessContextResolverExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusKogitoProcessContextResolver
implements KogitoProcessContextResolverExtension {
    private static final Logger logger = LoggerFactory.getLogger(QuarkusKogitoProcessContextResolver.class);

    public Map<String, Function<KogitoProcessContext, Object>> getKogitoProcessContextResolver() {
        return Map.of("identity", this::resolveInitiator);
    }

    private String resolveInitiator(KogitoProcessContext context) {
        try {
            SecurityIdentity identity = (SecurityIdentity)Arc.container().select(SecurityIdentity.class, new Annotation[0]).get();
            return identity.isAnonymous() ? "anonymous" : identity.getPrincipal().getName();
        }
        catch (RuntimeException ex) {
            logger.warn("Unable to resolve quarkus user identity", (Throwable)ex);
            return null;
        }
    }
}

