/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.restclient.runtime.RestClientBase;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

public class RestClientBuilderFactory
extends RestClientBase {
    public RestClientBuilderFactory(Class<?> proxyType, String baseUriFromAnnotation, String configKey) {
        super(proxyType, baseUriFromAnnotation, configKey, new Class[0]);
    }

    public static RestClientBuilder build(Class<?> restClass) {
        RegisterRestClient annotation = restClass.getAnnotation(RegisterRestClient.class);
        RestClientBuilderFactory instance = new RestClientBuilderFactory(restClass, annotation.baseUri(), annotation.configKey());
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        instance.configureBaseUrl(builder);
        instance.configureTimeouts(builder);
        instance.configureProviders(builder);
        instance.configureSsl(builder);
        instance.configureProxy(builder);
        instance.configureRedirects(builder);
        instance.configureQueryParamStyle(builder);
        instance.configureCustomProperties(builder);
        InstanceHandle managedExecutor = Arc.container().instance(ManagedExecutor.class, new Annotation[0]);
        if (managedExecutor.isAvailable()) {
            builder.executorService((ExecutorService)managedExecutor.get());
        }
        return builder;
    }
}

