/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.kie.kogito.test.resources.ConditionalQuarkusTestResource;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaQuarkusTestResource
extends ConditionalQuarkusTestResource<KogitoKafkaContainer> {
    public static final String KOGITO_KAFKA_PROPERTY = "kafka.bootstrap.servers";
    public static final String KOGITO_KAFKA_TOPICS = "kogito.test.topics";
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaQuarkusTestResource.class);
    private List<String> topics = Collections.emptyList();

    public KafkaQuarkusTestResource() {
        super(new KogitoKafkaContainer());
    }

    @Override
    protected Map<String, String> getProperties() {
        return Collections.singletonMap(KOGITO_KAFKA_PROPERTY, "localhost:" + ((KogitoKafkaContainer)this.getTestResource()).getMappedPort());
    }

    public void init(Map<String, String> initArgs) {
        if (initArgs.containsKey(KOGITO_KAFKA_TOPICS)) {
            this.topics = Arrays.stream(initArgs.getOrDefault(KOGITO_KAFKA_TOPICS, "").split(",")).collect(Collectors.toList());
        }
    }

    @Override
    public Map<String, String> start() {
        Map<String, String> props = super.start();
        String bootstrap = props.get(KOGITO_KAFKA_PROPERTY);
        if (bootstrap != null) {
            try {
                AdminClient client = AdminClient.create(Collections.singletonMap("bootstrap.servers", bootstrap));
                List newTopics = this.topics.stream().map(e -> new NewTopic(e, 1, 1)).collect(Collectors.toList());
                CreateTopicsResult result = client.createTopics(newTopics);
                LOGGER.info("trying to create {}", (Object)result);
                result.all().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e2) {
                LOGGER.error("Error creating {}", this.topics, (Object)e2);
            }
        }
        return props;
    }

    public static class Conditional
    extends KafkaQuarkusTestResource {
        public Conditional() {
            this.enableConditional();
        }
    }
}

