/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.kogito.test.resources.ConditionalQuarkusTestResource;
import org.kie.kogito.testcontainers.KogitoKeycloakContainer;

public class KeycloakQuarkusTestResource
extends ConditionalQuarkusTestResource<KogitoKeycloakContainer> {
    public static final String KOGITO_KEYCLOAK_PROPERTY = "quarkus.oidc.auth-server-url";
    public static final String KOGITO_OIDC_TENANTS = "kogito.test.tenants";
    private List<String> tenants = Collections.emptyList();

    public KeycloakQuarkusTestResource() {
        super(new KogitoKeycloakContainer());
    }

    public void init(Map<String, String> initArgs) {
        if (initArgs.containsKey(KOGITO_OIDC_TENANTS)) {
            this.tenants = Arrays.stream(initArgs.getOrDefault(KOGITO_OIDC_TENANTS, "").split(",")).collect(Collectors.toList());
        }
    }

    @Override
    protected Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String url = String.format("http://localhost:%s/auth/realms/kogito", ((KogitoKeycloakContainer)this.getTestResource()).getMappedPort());
        properties.put(KOGITO_KEYCLOAK_PROPERTY, url);
        this.tenants.forEach(tenant -> properties.put(String.format("quarkus.oidc.%s.auth-server-url", tenant), url));
        return properties;
    }

    public static class Conditional
    extends KeycloakQuarkusTestResource {
        public Conditional() {
            this.enableConditional();
        }
    }
}

