/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.workflow.deployment;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.codegen.common.GeneratedFile;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.Generated;
import org.kie.kogito.codegen.VariableInfo;
import org.kie.kogito.codegen.process.persistence.proto.AbstractProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoEnum;
import org.kie.kogito.codegen.process.persistence.proto.ProtoField;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JandexProtoGenerator
extends AbstractProtoGenerator<ClassInfo> {
    private static final DotName ENUM_VALUE_ANNOTATION = DotName.createSimple((String)ProtoEnumValue.class.getName());
    private static final DotName generatedAnnotation = DotName.createSimple((String)Generated.class.getCanonicalName());
    private static final DotName variableInfoAnnotation = DotName.createSimple((String)VariableInfo.class.getCanonicalName());
    private static final DotName objectClass = DotName.createSimple((String)Object.class.getCanonicalName());
    private static final DotName modelClazz = DotName.createSimple((String)Model.class.getCanonicalName());
    private final IndexView index;

    JandexProtoGenerator(Collection<ClassInfo> modelClasses, Collection<ClassInfo> dataClasses, IndexView index) {
        super(modelClasses, dataClasses);
        this.index = index;
    }

    protected boolean isEnum(ClassInfo dataModel) {
        return dataModel.superName() != null && Enum.class.getName().equals(dataModel.superName().toString());
    }

    protected String modelClassName(ClassInfo dataModel) {
        return dataModel.asClass().name().toString();
    }

    protected Optional<String> extractName(ClassInfo clazz) {
        if (this.isHidden(clazz)) {
            return Optional.empty();
        }
        String name = clazz.simpleName();
        String altName = this.getReferenceOfModel(clazz, "name");
        if (altName != null) {
            name = altName;
        }
        return Optional.of(name);
    }

    protected ProtoMessage messageFromClass(Proto proto, Set<String> alreadyGenerated, ClassInfo clazz, String messageComment, String fieldComment) throws Exception {
        Optional<String> optionalName = this.extractName(clazz);
        if (!optionalName.isPresent()) {
            return null;
        }
        String name = optionalName.get();
        ProtoMessage message = new ProtoMessage(name, clazz.name().prefix().toString());
        for (FieldInfo pd : this.extractAllFields(clazz)) {
            String protoType;
            if (Modifier.isStatic(pd.flags()) || Modifier.isTransient(pd.flags())) continue;
            Object completeFieldComment = "id".equals(pd.name()) && clazz.interfaceTypes().stream().anyMatch(t -> t.name().equals((Object)modelClazz)) ? fieldComment.replace("Index.NO", "Index.YES") : fieldComment;
            AnnotationInstance variableInfo = pd.annotation(variableInfoAnnotation);
            if (variableInfo != null) {
                completeFieldComment = fieldComment + "\n @VariableInfo(tags=\"" + variableInfo.value("tags").asString() + "\")";
            }
            String fieldTypeString = pd.type().name().toString();
            DotName fieldType = pd.type().name();
            if (this.isArray(pd)) {
                fieldTypeString = "Array";
                fieldType = pd.type().asArrayType().component().name();
                protoType = this.protoType(fieldType.toString());
            } else if (this.isCollection(pd)) {
                List typeParameters;
                fieldTypeString = "Collection";
                List list = typeParameters = pd.type().kind() == Type.Kind.CLASS ? Collections.emptyList() : pd.type().asParameterizedType().arguments();
                if (typeParameters.isEmpty()) {
                    throw new IllegalArgumentException("Field " + pd.name() + " of class " + clazz.name().toString() + " uses collection without type information");
                }
                fieldType = ((Type)typeParameters.get(0)).name();
                protoType = this.protoType(fieldType.toString());
            } else {
                protoType = this.protoType(fieldTypeString);
            }
            if (protoType == null) {
                ClassInfo classInfo = this.index.getClassByName(fieldType);
                if (classInfo == null) {
                    throw new IllegalStateException("Cannot find class info in jandex index for " + fieldType);
                }
                Optional optionalProtoType = this.internalGenerate(proto, alreadyGenerated, messageComment, fieldComment, classInfo);
                if (!optionalProtoType.isPresent()) {
                    return message;
                }
                protoType = (String)optionalProtoType.get();
            }
            ProtoField protoField = message.addField(this.applicabilityByType(fieldTypeString), protoType, pd.name());
            protoField.setComment((String)completeFieldComment);
            if (!"kogito.Serializable".equals(protoType)) continue;
            protoField.setOption(String.format("[(%s) = \"%s\"]", "kogito_java_class", fieldTypeString.equals("Array") ? pd.type().toString() : pd.type().name().toString()));
        }
        message.setComment(messageComment);
        proto.addMessage(message);
        return message;
    }

    private boolean isCollection(FieldInfo pd) {
        if (pd.type().kind() == Type.Kind.PARAMETERIZED_TYPE || pd.type().kind() == Type.Kind.CLASS) {
            try {
                Class<?> clazz = Class.forName(pd.type().name().toString());
                return Collection.class.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isArray(FieldInfo pd) {
        return pd.type().kind() == Type.Kind.ARRAY && pd.type().asArrayType().component().kind() != Type.Kind.PRIMITIVE;
    }

    private Collection<FieldInfo> extractAllFields(ClassInfo clazz) {
        ArrayList<FieldInfo> toReturn = new ArrayList<FieldInfo>(clazz.fields());
        DotName superClass = clazz.superName();
        if (superClass != null && !superClass.equals((Object)objectClass)) {
            toReturn.addAll(this.extractAllFields(this.index.getClassByName(superClass)));
        }
        return toReturn;
    }

    protected ProtoEnum enumFromClass(Proto proto, ClassInfo clazz) {
        try {
            return this.extractName(clazz).map(name -> {
                ProtoEnum modelEnum = new ProtoEnum(name, clazz.name().prefix().toString());
                clazz.fields().stream().filter(FieldInfo::isEnumConstant).sorted(Comparator.comparing(FieldInfo::name)).forEach(f -> this.addEnumField((FieldInfo)f, modelEnum));
                proto.addEnum(modelEnum);
                return modelEnum;
            }).orElse(null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Malformed class " + clazz.name() + " " + e.getMessage(), e);
        }
    }

    private void addEnumField(FieldInfo field, ProtoEnum pEnum) {
        AnnotationValue number;
        AnnotationInstance annotation = field.annotation(ENUM_VALUE_ANNOTATION);
        Integer ordinal = null;
        boolean sortedWithAnnotation = false;
        if (annotation != null && (number = annotation.value("number")) != null) {
            sortedWithAnnotation = true;
            ordinal = number.asInt();
        }
        if (ordinal == null) {
            String clazzName = field.type().name().toString();
            ClassInfo classByName = this.index.getClassByName(DotName.createSimple((String)clazzName));
            if (!classByName.isEnum()) {
                throw new IllegalArgumentException(String.format("Unsupported type, class %s, is not an enum.", clazzName));
            }
            List constants = classByName.unsortedFields().stream().filter(FieldInfo::isEnumConstant).collect(Collectors.toList());
            ordinal = constants.indexOf(field);
            if (ordinal == -1) {
                throw new IllegalArgumentException(String.format("Can not find enum field ordinal for %s.%s", clazzName, field.name()));
            }
        }
        pEnum.addField(field.name(), ordinal, sortedWithAnnotation);
    }

    protected Optional<GeneratedFile> generateModelClassProto(ClassInfo modelClazz) {
        String processId = this.getReferenceOfModel(modelClazz, "reference");
        String name = this.getReferenceOfModel(modelClazz, "name");
        if (processId != null) {
            Proto modelProto = this.generate("@Indexed", "@Field(index = Index.YES, store = Store.YES) @SortableField", modelClazz.name().prefix().toString() + "." + processId, modelClazz, new String[]{"import \"kogito-index.proto\";", "import \"kogito-types.proto\";", "option kogito_model = \"" + name + "\";", "option kogito_id = \"" + processId + "\";"});
            if (modelProto.getMessages().isEmpty()) {
                return Optional.empty();
            }
            ProtoMessage modelMessage = modelProto.getMessages().stream().filter(msg -> msg.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find model message"));
            modelMessage.addField("optional", "org.kie.kogito.index.model.KogitoMetadata", "metadata").setComment("@Field(index = Index.YES, store = Store.YES) @SortableField");
            return Optional.of(this.generateProtoFiles(processId, modelProto));
        }
        return Optional.empty();
    }

    protected String getReferenceOfModel(ClassInfo modelClazz, String name) {
        AnnotationInstance generatedData = modelClazz.classAnnotation(generatedAnnotation);
        if (generatedData != null) {
            return generatedData.value(name).asString();
        }
        return null;
    }

    protected boolean isHidden(ClassInfo modelClazz) {
        AnnotationInstance generatedData = modelClazz.classAnnotation(generatedAnnotation);
        if (generatedData != null) {
            return generatedData.value("hidden").asBoolean();
        }
        return false;
    }

    public static ProtoGenerator.Builder<ClassInfo, JandexProtoGenerator> builder(IndexView index) {
        return new JandexProtoGeneratorBuilder(index);
    }

    private static class JandexProtoGeneratorBuilder
    extends AbstractProtoGenerator.AbstractProtoGeneratorBuilder<ClassInfo, JandexProtoGenerator> {
        private static final Logger LOGGER = LoggerFactory.getLogger(JandexProtoGeneratorBuilder.class);
        private final IndexView index;

        private JandexProtoGeneratorBuilder(IndexView index) {
            this.index = index;
        }

        protected Collection<ClassInfo> extractDataClasses(Collection<ClassInfo> modelClasses) {
            if (this.dataClasses != null || modelClasses == null) {
                LOGGER.info("Using provided dataClasses instead of extracting from modelClasses. This should happen only during tests.");
                return this.dataClasses;
            }
            HashSet<ClassInfo> dataModelClasses = new HashSet<ClassInfo>();
            for (ClassInfo modelClazz : modelClasses) {
                for (FieldInfo pd : modelClazz.fields()) {
                    ClassInfo clazzInfo;
                    if (pd.type().name().toString().startsWith("java.lang") || pd.type().name().toString().startsWith("java.util") || pd.type().name().toString().equals(Date.class.getCanonicalName()) || (clazzInfo = this.index.getClassByName(pd.type().name())) == null) continue;
                    dataModelClasses.add(clazzInfo);
                }
            }
            return dataModelClasses;
        }

        public JandexProtoGenerator build(Collection<ClassInfo> modelClasses) {
            return new JandexProtoGenerator(modelClasses, this.extractDataClasses(modelClasses), this.index);
        }
    }
}

