/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest.auth;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.auth.User;
import io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kogito.workitem.rest.auth.TokenRetriever;

public abstract class OAuth2AuthToken<T>
implements TokenRetriever {
    private static final Map<Object, User> usersCache = new ConcurrentHashMap<Object, User>();
    private final String tokenUrl;
    private final String refreshUrl;

    protected OAuth2AuthToken(String tokenUrl, String refreshUrl) {
        this.tokenUrl = tokenUrl;
        this.refreshUrl = refreshUrl;
    }

    @Override
    public String getToken(Map<String, Object> parameters) {
        User user = usersCache.compute(this.getCacheKey(parameters), this::getOrRefreshUser);
        return user.principal().getString("access_token");
    }

    private User getOrRefreshUser(Object c, User user) {
        Object cacheKey = c;
        if (user == null) {
            return this.createOAuth2(this.tokenUrl, cacheKey).authenticateAndAwait(this.getJsonObject(cacheKey));
        }
        if (user.expired()) {
            return this.createOAuth2(this.refreshUrl != null ? this.refreshUrl : this.tokenUrl, cacheKey).refreshAndAwait(user);
        }
        return user;
    }

    private OAuth2Auth createOAuth2(String tokenPath, T cacheKey) {
        return OAuth2Auth.create((Vertx)Vertx.vertx(), (OAuth2Options)this.fillOptions(new OAuth2Options().setTokenPath(tokenPath), cacheKey));
    }

    protected abstract OAuth2Options fillOptions(OAuth2Options var1, T var2);

    protected abstract JsonObject getJsonObject(T var1);

    protected abstract T getCacheKey(Map<String, Object> var1);
}

