/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest;

import io.vertx.core.http.HttpMethod;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jbpm.process.core.Process;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.WorkItemExecutionException;
import org.kogito.workitem.rest.RestWorkItemHandlerUtils;
import org.kogito.workitem.rest.auth.ApiKeyAuthDecorator;
import org.kogito.workitem.rest.auth.AuthDecorator;
import org.kogito.workitem.rest.auth.BasicAuthDecorator;
import org.kogito.workitem.rest.auth.BearerTokenAuthDecorator;
import org.kogito.workitem.rest.bodybuilders.DefaultWorkItemHandlerBodyBuilder;
import org.kogito.workitem.rest.bodybuilders.RestWorkItemHandlerBodyBuilder;
import org.kogito.workitem.rest.decorators.ParamsDecorator;
import org.kogito.workitem.rest.decorators.PrefixParamsDecorator;
import org.kogito.workitem.rest.decorators.RequestDecorator;
import org.kogito.workitem.rest.pathresolvers.DefaultPathParamResolver;
import org.kogito.workitem.rest.pathresolvers.PathParamResolver;
import org.kogito.workitem.rest.resulthandlers.DefaultRestWorkItemHandlerResult;
import org.kogito.workitem.rest.resulthandlers.RestWorkItemHandlerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestWorkItemHandler
implements KogitoWorkItemHandler {
    public static final String REST_TASK_TYPE = "Rest";
    public static final String URL = "Url";
    public static final String METHOD = "Method";
    public static final String CONTENT_DATA = "ContentData";
    public static final String RESULT = "Result";
    public static final String USER = "Username";
    public static final String PASSWORD = "Password";
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String RESULT_HANDLER = "ResultHandler";
    public static final String BODY_BUILDER = "BodyBuilder";
    public static final String PARAMS_DECORATOR = "ParamsDecorator";
    public static final String PATH_PARAM_RESOLVER = "PathParamResolver";
    public static final String AUTH_METHOD = "AuthMethod";
    private static final Logger logger = LoggerFactory.getLogger(RestWorkItemHandler.class);
    private static final RestWorkItemHandlerResult DEFAULT_RESULT_HANDLER = new DefaultRestWorkItemHandlerResult();
    private static final RestWorkItemHandlerBodyBuilder DEFAULT_BODY_BUILDER = new DefaultWorkItemHandlerBodyBuilder();
    private static final ParamsDecorator DEFAULT_PARAMS_DECORATOR = new PrefixParamsDecorator();
    private static final PathParamResolver DEFAULT_PATH_PARAM_RESOLVER = new DefaultPathParamResolver();
    private static final Map<String, RestWorkItemHandlerResult> resultHandlers = new ConcurrentHashMap<String, RestWorkItemHandlerResult>();
    private static final Map<String, RestWorkItemHandlerBodyBuilder> bodyBuilders = new ConcurrentHashMap<String, RestWorkItemHandlerBodyBuilder>();
    private static final Map<String, ParamsDecorator> paramsDecorators = new ConcurrentHashMap<String, ParamsDecorator>();
    private static final Map<String, PathParamResolver> pathParamsResolvers = new ConcurrentHashMap<String, PathParamResolver>();
    private static final Map<String, AuthDecorator> authDecoratorsMap = new ConcurrentHashMap<String, AuthDecorator>();
    private static final Collection<AuthDecorator> DEFAULT_AUTH_DECORATORS = Arrays.asList(new ApiKeyAuthDecorator(), new BasicAuthDecorator(), new BearerTokenAuthDecorator());
    private WebClient client;
    private Collection<RequestDecorator> requestDecorators;

    public RestWorkItemHandler(WebClient client) {
        this.client = client;
        this.requestDecorators = StreamSupport.stream(ServiceLoader.load(RequestDecorator.class).spliterator(), false).collect(Collectors.toList());
    }

    public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        int port;
        Class<?> targetInfo = this.getTargetInfo(workItem);
        logger.debug("Using target {}", targetInfo);
        HashMap<String, Object> parameters = new HashMap<String, Object>(workItem.getParameters());
        parameters.remove("TaskName");
        String endPoint = RestWorkItemHandlerUtils.getParam(parameters, URL, String.class, null);
        if (endPoint == null) {
            throw new IllegalArgumentException("Missing required parameter Url");
        }
        HttpMethod method = RestWorkItemHandlerUtils.getParam(parameters, METHOD, HttpMethod.class, HttpMethod.GET);
        String hostProp = RestWorkItemHandlerUtils.getParam(parameters, HOST, String.class, "localhost");
        int portProp = RestWorkItemHandlerUtils.getParam(parameters, PORT, Integer.class, 80);
        RestWorkItemHandlerResult resultHandler = RestWorkItemHandlerUtils.getClassParam(parameters, RESULT_HANDLER, RestWorkItemHandlerResult.class, DEFAULT_RESULT_HANDLER, resultHandlers);
        RestWorkItemHandlerBodyBuilder bodyBuilder = RestWorkItemHandlerUtils.getClassParam(parameters, BODY_BUILDER, RestWorkItemHandlerBodyBuilder.class, DEFAULT_BODY_BUILDER, bodyBuilders);
        ParamsDecorator paramsDecorator = RestWorkItemHandlerUtils.getClassParam(parameters, PARAMS_DECORATOR, ParamsDecorator.class, DEFAULT_PARAMS_DECORATOR, paramsDecorators);
        PathParamResolver pathParamResolver = RestWorkItemHandlerUtils.getClassParam(parameters, PATH_PARAM_RESOLVER, PathParamResolver.class, DEFAULT_PATH_PARAM_RESOLVER, pathParamsResolvers);
        Collection<AuthDecorator> authDecorators = RestWorkItemHandlerUtils.getClassListParam(parameters, AUTH_METHOD, AuthDecorator.class, DEFAULT_AUTH_DECORATORS, authDecoratorsMap);
        logger.debug("Filtered parameters are {}", parameters);
        endPoint = (String)pathParamResolver.apply(endPoint, parameters);
        Optional<URL> url = this.getUrl(endPoint);
        String host = url.map(URL::getHost).orElse(hostProp);
        if (host == null) {
            host = hostProp;
        }
        if ((port = url.map(URL::getPort).orElse(portProp).intValue()) < 0) {
            port = portProp;
        }
        String path = url.map(URL::getPath).orElse(endPoint).replace(" ", "%20");
        HttpRequest request = this.client.request(method, port, host, path);
        this.requestDecorators.forEach(d -> d.decorate(workItem, parameters, request));
        authDecorators.forEach(d -> d.decorate(workItem, parameters, request));
        paramsDecorator.decorate(workItem, parameters, request);
        HttpResponse response = method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT) ? request.sendJsonAndAwait(bodyBuilder.apply(parameters)) : request.sendAndAwait();
        int statusCode = response.statusCode();
        if (statusCode < 200 || statusCode >= 300) {
            throw new WorkItemExecutionException(Integer.toString(statusCode), response.statusMessage());
        }
        manager.completeWorkItem(workItem.getStringId(), Collections.singletonMap(RESULT, resultHandler.apply(response, targetInfo)), new Policy[0]);
    }

    private Optional<URL> getUrl(String endPoint) {
        return Optional.ofNullable(endPoint).map(spec -> {
            try {
                return new URL((String)spec);
            }
            catch (MalformedURLException e) {
                return null;
            }
        });
    }

    private Class<?> getTargetInfo(KogitoWorkItem workItem) {
        String varName = (String)((WorkItemNode)((WorkItemNodeInstance)workItem.getNodeInstance()).getNode()).getIoSpecification().getOutputMappingBySources().get(RESULT);
        if (varName != null) {
            return this.getType(workItem.getProcessInstance(), varName);
        }
        logger.warn("no out mapping for {}", (Object)RESULT);
        return null;
    }

    private Class<?> getType(KogitoProcessInstance pi, String varName) {
        VariableScope variableScope = (VariableScope)((Process)pi.getProcess()).getDefaultContext("VariableScope");
        Variable variable = variableScope.findVariable(varName);
        if (variable != null) {
            return variable.getType().getObjectClass();
        }
        logger.warn("Cannot find definition for variable {}", (Object)varName);
        return null;
    }

    public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
    }
}

