/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest.auth;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.auth.User;
import io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kogito.workitem.rest.RestWorkItemHandlerUtils;
import org.kogito.workitem.rest.auth.AuthDecorator;

public abstract class OAuth2AuthDecorator<T>
implements AuthDecorator {
    private final String tokenUrl;
    private final String refreshUrl;
    private static Map<Object, User> usersCache = new ConcurrentHashMap<Object, User>();

    protected OAuth2AuthDecorator(String tokenUrl, String refreshUrl) {
        this.tokenUrl = tokenUrl;
        this.refreshUrl = refreshUrl;
    }

    @Override
    public void decorate(KogitoWorkItem item, Map<String, Object> parameters, HttpRequest<?> request) {
        request.bearerTokenAuthentication(this.getToken(parameters));
    }

    public String getToken(Map<String, Object> parameters) {
        User user = usersCache.compute(this.getCacheKey(parameters), this::getOrRefreshUser);
        return user.principal().getString("access_token");
    }

    private User getOrRefreshUser(Object c, User user) {
        Object cacheKey = c;
        if (user == null) {
            return this.createOAuth2(this.tokenUrl, cacheKey).authenticateAndAwait(this.getJsonObject(cacheKey));
        }
        if (user.expired()) {
            return this.createOAuth2(this.refreshUrl != null ? this.refreshUrl : this.tokenUrl, cacheKey).refreshAndAwait(user);
        }
        return user;
    }

    private OAuth2Auth createOAuth2(String tokenPath, T cacheKey) {
        return OAuth2Auth.create((Vertx)RestWorkItemHandlerUtils.vertx(), (OAuth2Options)this.fillOptions(new OAuth2Options().setTokenPath(tokenPath), cacheKey));
    }

    protected abstract OAuth2Options fillOptions(OAuth2Options var1, T var2);

    protected abstract JsonObject getJsonObject(T var1);

    protected abstract T getCacheKey(Map<String, Object> var1);
}

