/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest.auth;

import io.vertx.mutiny.ext.web.client.HttpRequest;
import java.util.Map;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.kogito.workitem.rest.RestWorkItemHandlerUtils;
import org.kogito.workitem.rest.auth.AuthDecorator;

public class ApiKeyAuthDecorator
implements AuthDecorator {
    public static final String KEY = "apiKey";
    public static final String KEY_PREFIX = "apiKeyPrefix";
    private final String paramName;
    private final Location location;

    public ApiKeyAuthDecorator() {
        this("X-API-KEY", Location.HEADER);
    }

    public ApiKeyAuthDecorator(String paramName, Location location) {
        this.paramName = paramName;
        this.location = location;
    }

    @Override
    public void decorate(KogitoWorkItem item, Map<String, Object> parameters, HttpRequest<?> request) {
        String apiKey = ApiKeyAuthDecorator.getApiKey(RestWorkItemHandlerUtils.getParam(parameters, KEY_PREFIX, String.class, null), RestWorkItemHandlerUtils.getParam(parameters, KEY, String.class, ""));
        if (!ConversionUtils.isEmpty((String)apiKey)) {
            switch (this.location) {
                case QUERY: {
                    request.addQueryParam(this.paramName, apiKey);
                    break;
                }
                default: {
                    request.putHeader(this.paramName, apiKey);
                }
            }
        }
    }

    private static String getApiKey(String apiKeyPrefix, String apiKey) {
        return apiKeyPrefix != null ? apiKeyPrefix + " " + apiKey : apiKey;
    }

    public static enum Location {
        HEADER,
        QUERY,
        COOKIE;

    }
}

