/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest.auth;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import java.util.Map;
import org.kogito.workitem.rest.RestWorkItemHandlerUtils;
import org.kogito.workitem.rest.auth.ClientInfo;
import org.kogito.workitem.rest.auth.OAuth2AuthDecorator;

public class ClientOAuth2AuthDecorator
extends OAuth2AuthDecorator<ClientInfo> {
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_SECRET = "clientSecret";
    private final JsonObject object = new JsonObject();

    public ClientOAuth2AuthDecorator(String tokenUrl, String refreshUrl) {
        super(tokenUrl, refreshUrl);
    }

    @Override
    protected OAuth2Options fillOptions(OAuth2Options options, ClientInfo cacheKey) {
        return options.setFlow(OAuth2FlowType.CLIENT).setClientId(cacheKey.getClientId()).setClientSecret(cacheKey.getClientId());
    }

    @Override
    protected JsonObject getJsonObject(ClientInfo cacheKey) {
        return this.object;
    }

    @Override
    protected ClientInfo getCacheKey(Map<String, Object> parameters) {
        return new ClientInfo(RestWorkItemHandlerUtils.getParam(parameters, CLIENT_ID), RestWorkItemHandlerUtils.getParam(parameters, CLIENT_SECRET));
    }
}

