/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest;

import io.vertx.core.http.HttpMethod;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.kogito.workitem.rest.RestWorkItemHandlerParamResolver;
import org.kogito.workitem.rest.RestWorkItemHandlerResult;

public class RestWorkItemHandler
implements KogitoWorkItemHandler {
    public static final String REST_TASK_TYPE = "Rest Task";
    public static final String ENDPOINT = "endpoint";
    public static final String METHOD = "method";
    public static final String PARAMETER = "Parameter";
    public static final String RESULT = "Result";
    public static final String RESULT_HANDLER = "ResultHandler";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String HOST = "host";
    public static final String PORT = "port";
    private WebClient client;

    public RestWorkItemHandler(WebClient client) {
        this.client = client;
    }

    public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        HttpResponse response;
        HashMap<String, Object> parameters = new HashMap<String, Object>(workItem.getParameters());
        String endPoint = this.getParam(parameters, ENDPOINT, String.class);
        HttpMethod method = HttpMethod.valueOf((String)this.getParam(parameters, METHOD, String.class).toUpperCase());
        Map<String, Object> inputModel = this.getParam(parameters, PARAMETER, Object.class);
        String user = (String)parameters.remove(USER);
        String password = (String)parameters.remove(PASSWORD);
        String hostProp = (String)parameters.remove(HOST);
        String portProp = (String)parameters.remove(PORT);
        RestWorkItemHandlerResult resultHandler = this.getParam(parameters, RESULT_HANDLER, RestWorkItemHandlerResult.class);
        RestUnaryOperator resolver = new RestUnaryOperator(inputModel);
        URI uri = URI.create(endPoint = RestWorkItemHandler.resolvePathParams(endPoint, parameters, resolver));
        String host = uri.getHost() != null ? uri.getHost() : hostProp;
        int port = uri.getPort() > 0 ? uri.getPort() : Integer.parseInt(portProp);
        HttpRequest request = this.client.request(method, port, host, uri.getPath());
        if (user != null && !user.trim().isEmpty() && password != null && !password.trim().isEmpty()) {
            request.basicAuthentication(user, password);
        }
        if (method == HttpMethod.POST || method == HttpMethod.PUT) {
            Map<String, Object> body = parameters.isEmpty() ? inputModel : parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> resolver.apply(e.getValue())));
            response = request.sendJsonAndAwait((Object)body);
        } else {
            response = request.sendAndAwait();
        }
        manager.completeWorkItem(workItem.getStringId(), Collections.singletonMap(RESULT, resultHandler.apply(inputModel, response.bodyAsJsonObject())), new Policy[0]);
    }

    public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
    }

    static String resolvePathParams(String endPoint, Map<String, Object> parameters, UnaryOperator<Object> resolver) {
        HashSet<String> toRemove = new HashSet<String>();
        int start = endPoint.indexOf(123);
        if (start == -1) {
            return endPoint;
        }
        StringBuilder sb = new StringBuilder(endPoint);
        while (start != -1) {
            int end = sb.indexOf("}", start);
            if (end == -1) {
                throw new IllegalArgumentException("malformed endpoint should contain enclosing '}' " + endPoint);
            }
            String key = sb.substring(start + 1, end);
            Object value = resolver.apply(parameters.get(key));
            if (value == null) {
                throw new IllegalArgumentException("missing parameter " + key);
            }
            toRemove.add(key);
            sb.replace(start, end + 1, resolver.apply(parameters.get(key)).toString());
            start = sb.indexOf("{", end);
        }
        parameters.keySet().removeAll(toRemove);
        return sb.toString();
    }

    private <T> T getParam(Map<String, Object> parameters, String paramName, Class<T> type) {
        Object value = parameters.remove(paramName);
        if (value == null) {
            throw new IllegalArgumentException("Missing required parameter " + paramName);
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Parameter paramName should be of type " + type + " but it is of type " + value.getClass());
        }
        return type.cast(value);
    }

    static class RestUnaryOperator
    implements UnaryOperator<Object> {
        private Object inputModel;

        public RestUnaryOperator(Object inputModel) {
            this.inputModel = inputModel;
        }

        @Override
        public Object apply(Object value) {
            return value instanceof RestWorkItemHandlerParamResolver ? ((RestWorkItemHandlerParamResolver)value).apply(this.inputModel) : value;
        }
    }
}

