/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest;

import io.vertx.core.http.HttpMethod;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jbpm.process.core.Process;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.impl.WorkItemHandlerParamResolver;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.kogito.workitem.rest.RestWorkItemTargetInfo;
import org.kogito.workitem.rest.bodybuilders.DefaultWorkItemHandlerBodyBuilder;
import org.kogito.workitem.rest.bodybuilders.RestWorkItemHandlerBodyBuilder;
import org.kogito.workitem.rest.resulthandlers.DefaultRestWorkItemHandlerResult;
import org.kogito.workitem.rest.resulthandlers.RestWorkItemHandlerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestWorkItemHandler
implements KogitoWorkItemHandler {
    public static final String REST_TASK_TYPE = "Rest";
    public static final String URL = "Url";
    public static final String METHOD = "Method";
    public static final String CONTENT_DATA = "ContentData";
    public static final String RESULT = "Result";
    public static final String USER = "Username";
    public static final String PASSWORD = "Password";
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String RESULT_HANDLER = "ResultHandler";
    public static final String BODY_BUILDER = "BodyBuilder";
    private static final Logger logger = LoggerFactory.getLogger(RestWorkItemHandler.class);
    private static final RestWorkItemHandlerResult DEFAULT_RESULT_HANDLER = new DefaultRestWorkItemHandlerResult();
    private static final RestWorkItemHandlerBodyBuilder DEFAULT_BODY_BUILDER = new DefaultWorkItemHandlerBodyBuilder();
    private WebClient client;

    public RestWorkItemHandler(WebClient client) {
        this.client = client;
    }

    public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        RestWorkItemTargetInfo targetInfo = this.getTargetInfo(workItem);
        logger.debug("Using target {}", (Object)targetInfo);
        HashMap<String, Object> parameters = new HashMap<String, Object>(workItem.getParameters());
        String endPoint = this.getParam(parameters, URL, String.class, null);
        if (endPoint == null) {
            throw new IllegalArgumentException("Missing required parameter Url");
        }
        HttpMethod method = HttpMethod.valueOf((String)this.getParam(parameters, METHOD, String.class, "GET").toUpperCase());
        Map inputModel = this.getParam(parameters, CONTENT_DATA, Object.class, Collections.emptyMap());
        String user = this.getParam(parameters, USER, String.class, null);
        String password = this.getParam(parameters, PASSWORD, String.class, null);
        String hostProp = this.getParam(parameters, HOST, String.class, "localhost");
        int portProp = this.getParam(parameters, PORT, Integer.class, 8080);
        RestWorkItemHandlerResult resultHandler = this.getParam(parameters, RESULT_HANDLER, RestWorkItemHandlerResult.class, DEFAULT_RESULT_HANDLER);
        RestWorkItemHandlerBodyBuilder bodyBuilder = this.getParam(parameters, BODY_BUILDER, RestWorkItemHandlerBodyBuilder.class, DEFAULT_BODY_BUILDER);
        logger.debug("Filtered parameters are {}", parameters);
        RestUnaryOperator resolver = new RestUnaryOperator(inputModel);
        endPoint = RestWorkItemHandler.resolvePathParams(endPoint, parameters, resolver);
        URI uri = URI.create(endPoint);
        String host = uri.getHost() != null ? uri.getHost() : hostProp;
        int port = uri.getPort() > 0 ? uri.getPort() : portProp;
        HttpRequest request = this.client.request(method, port, host, uri.getPath());
        if (user != null && !user.trim().isEmpty() && password != null && !password.trim().isEmpty()) {
            request.basicAuthentication(user, password);
        }
        HttpResponse response = method == HttpMethod.POST || method == HttpMethod.PUT ? request.sendJsonAndAwait(bodyBuilder.apply(inputModel, parameters, resolver)) : request.sendAndAwait();
        manager.completeWorkItem(workItem.getStringId(), targetInfo != null ? Collections.singletonMap(RESULT, resultHandler.apply(targetInfo, response)) : Collections.emptyMap(), new Policy[0]);
    }

    private RestWorkItemTargetInfo getTargetInfo(KogitoWorkItem workItem) {
        String varName = ((WorkItemNode)((WorkItemNodeInstance)workItem.getNodeInstance()).getNode()).getOutMapping(RESULT);
        if (varName != null) {
            KogitoProcessInstance pi = workItem.getProcessInstance();
            Object instance = pi.getVariables().get(varName);
            Class<?> type = this.getType(pi, varName);
            if (instance != null || type != null) {
                return new RestWorkItemTargetInfo(instance, type);
            }
        }
        logger.warn("no out mapping for {}", (Object)RESULT);
        return null;
    }

    private Class<?> getType(KogitoProcessInstance pi, String varName) {
        VariableScope variableScope = (VariableScope)((Process)pi.getProcess()).getDefaultContext("VariableScope");
        Variable variable = variableScope.findVariable(varName);
        if (variable != null) {
            try {
                return Class.forName(variable.getType().getStringType());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Problem loading type " + variable.getType().getStringType(), e);
            }
        }
        logger.warn("Cannot find definition for variable {}", (Object)varName);
        return null;
    }

    public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
    }

    static String resolvePathParams(String endPoint, Map<String, Object> parameters, UnaryOperator<Object> resolver) {
        HashSet<String> toRemove = new HashSet<String>();
        int start = endPoint.indexOf(123);
        if (start == -1) {
            return endPoint;
        }
        StringBuilder sb = new StringBuilder(endPoint);
        while (start != -1) {
            int end = sb.indexOf("}", start);
            if (end == -1) {
                throw new IllegalArgumentException("malformed endpoint should contain enclosing '}' " + endPoint);
            }
            String key = sb.substring(start + 1, end);
            Object value = resolver.apply(parameters.get(key));
            if (value == null) {
                throw new IllegalArgumentException("missing parameter " + key);
            }
            toRemove.add(key);
            sb.replace(start, end + 1, resolver.apply(parameters.get(key)).toString());
            start = sb.indexOf("{", end);
        }
        parameters.keySet().removeAll(toRemove);
        return sb.toString();
    }

    private <T> T getParam(Map<String, Object> parameters, String paramName, Class<T> type, T defaultValue) {
        Object value = parameters.remove(paramName);
        if (value == null) {
            value = defaultValue;
        } else if (!type.isAssignableFrom(value.getClass())) {
            if (type.isAssignableFrom(Integer.class) && CharSequence.class.isAssignableFrom(value.getClass())) {
                try {
                    value = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException ex) {
                    value = defaultValue;
                }
            } else {
                throw new IllegalArgumentException("Parameter paramName should be of type " + type + " but it is of type " + value.getClass());
            }
        }
        return type.cast(value);
    }

    static class RestUnaryOperator
    implements UnaryOperator<Object> {
        private Object inputModel;

        public RestUnaryOperator(Object inputModel) {
            this.inputModel = inputModel;
        }

        @Override
        public Object apply(Object value) {
            return value instanceof WorkItemHandlerParamResolver ? ((WorkItemHandlerParamResolver)value).apply(this.inputModel) : value;
        }
    }
}

