/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestWorkItemHandlerUtils {
    private static final Logger logger = LoggerFactory.getLogger(RestWorkItemHandlerUtils.class);

    private RestWorkItemHandlerUtils() {
    }

    public static <T> T mergeObject(T target, JsonObject jsonObject) {
        return (T)(target instanceof ObjectNode ? RestWorkItemHandlerUtils.mergeJson(jsonObject, (ObjectNode)target) : RestWorkItemHandlerUtils.mergeBean(jsonObject, target));
    }

    private static <T> T mergeBean(JsonObject src, T target) {
        try {
            PropertyDescriptor[] propertyDescritors = Introspector.getBeanInfo(target.getClass()).getPropertyDescriptors();
            src.forEach(e -> RestWorkItemHandlerUtils.setValue(propertyDescritors, target, (String)e.getKey(), e.getValue()));
            return target;
        }
        catch (IntrospectionException e2) {
            throw new IllegalArgumentException("Wrong bean " + target, e2);
        }
    }

    private static void setValue(PropertyDescriptor[] propertyDescritors, Object target, String name, Object value) {
        for (PropertyDescriptor descriptor : propertyDescritors) {
            if (!descriptor.getName().equals(name)) continue;
            try {
                descriptor.getWriteMethod().invoke(target, value);
            }
            catch (ReflectiveOperationException e) {
                logger.error("Error invoking setter for {} with value {}", new Object[]{name, value, e});
            }
            return;
        }
        logger.warn("No property found for name {}", (Object)name);
    }

    private static ObjectNode mergeJson(JsonObject src, ObjectNode target) {
        src.forEach(e -> RestWorkItemHandlerUtils.setValue(target, (String)e.getKey(), e.getValue()));
        return target;
    }

    private static void setValue(ObjectNode result, String key, Object value) {
        if (value instanceof Double) {
            result.put(key, (Double)value);
        } else if (value instanceof Float) {
            result.put(key, (Float)value);
        } else if (value instanceof Long) {
            result.put(key, (Long)value);
        } else if (value instanceof Integer) {
            result.put(key, (Integer)value);
        } else if (value instanceof Short) {
            result.put(key, (Short)value);
        } else if (value instanceof Boolean) {
            result.put(key, (Boolean)value);
        } else if (value instanceof String) {
            result.put(key, (String)value);
        } else if (value instanceof JsonObject) {
            result.set(key, (JsonNode)RestWorkItemHandlerUtils.mergeJson((JsonObject)value, result.objectNode()));
        } else if (value instanceof JsonArray) {
            ArrayNode array = result.arrayNode();
            ((JsonArray)value).forEach(v -> RestWorkItemHandlerUtils.addValue(array, v));
            result.set(key, (JsonNode)array);
        } else {
            logger.warn("Unrecognized data type for object {} class {}", value, value.getClass());
        }
    }

    private static void addValue(ArrayNode result, Object value) {
        if (value instanceof Double) {
            result.add((Double)value);
        } else if (value instanceof Float) {
            result.add((Float)value);
        } else if (value instanceof Long) {
            result.add((Long)value);
        } else if (value instanceof Integer) {
            result.add((Integer)value);
        } else if (value instanceof Short) {
            result.add((int)((Short)value).shortValue());
        } else if (value instanceof Boolean) {
            result.add((Boolean)value);
        } else if (value instanceof String) {
            result.add((String)value);
        } else if (value instanceof JsonObject) {
            result.add((JsonNode)RestWorkItemHandlerUtils.mergeJson((JsonObject)value, result.objectNode()));
        } else if (value instanceof JsonArray) {
            ArrayNode array = result.arrayNode();
            ((JsonArray)value).forEach(v -> RestWorkItemHandlerUtils.addValue(array, v));
            result.add((JsonNode)array);
        } else {
            logger.warn("Unrecognized data type for object {} class {}", value, value.getClass());
        }
    }
}

