/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.workitem.rest;

import io.vertx.ext.web.client.WebClientOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.kogito.internal.utils.ConversionUtils;

public class RestWorkItemHandlerUtils {
    private RestWorkItemHandlerUtils() {
    }

    public static WebClientOptions sslWebClientOptions() {
        return new WebClientOptions().setSsl(true).setVerifyHost(false).setTrustAll(true);
    }

    public static String getParam(Map<String, Object> parameters, String paramName) {
        return RestWorkItemHandlerUtils.getParam(parameters, paramName, String.class, null);
    }

    public static <T> T getParam(Map<String, Object> parameters, String paramName, Class<T> type, T defaultValue) {
        Object value = parameters.remove(paramName);
        return (T)(value == null ? defaultValue : ConversionUtils.convert((Object)value, type, v -> v.toString().toUpperCase()));
    }

    public static <T> Collection<T> getClassListParam(Map<String, Object> parameters, String paramName, Class<T> clazz, Collection<T> defaultValue, Map<String, T> instances) {
        Object param = parameters.remove(paramName);
        if (param == null) {
            return defaultValue;
        }
        return param instanceof Collection ? (Collection)((Collection)param).stream().filter(Objects::nonNull).map(p -> RestWorkItemHandlerUtils.getClassParam(p, clazz, instances)).collect(Collectors.toList()) : Collections.singletonList(RestWorkItemHandlerUtils.getClassParam(param, clazz, instances));
    }

    private static <T> T getClassParam(Object param, Class<T> clazz, Map<String, T> instances) {
        if (clazz.isAssignableFrom(param.getClass())) {
            return clazz.cast(param);
        }
        if (param instanceof String) {
            return (T)instances.computeIfAbsent(param.toString(), k -> RestWorkItemHandlerUtils.loadClass(k, clazz));
        }
        throw new IllegalArgumentException(param + " is not a valid instance of class " + clazz);
    }

    public static <T> T getClassParam(Map<String, Object> parameters, String paramName, Class<T> clazz, T defaultValue, Map<String, T> instances) {
        Object param = parameters.remove(paramName);
        return param == null ? defaultValue : RestWorkItemHandlerUtils.getClassParam(param, clazz, instances);
    }

    private static <T> T loadClass(String className, Class<T> clazz) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className).asSubclass(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new IllegalArgumentException("Problem loading class " + className, e);
        }
    }
}

