/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules.units;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.reflective.util.ClassUtils;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.units.AbstractRuleUnitDescription;
import org.kie.kogito.rules.units.SimpleRuleUnitVariable;

public class ReflectiveRuleUnitDescription
extends AbstractRuleUnitDescription {
    private final Class<? extends RuleUnitData> ruleUnitClass;

    public ReflectiveRuleUnitDescription(InternalKnowledgePackage pkg, Class<? extends RuleUnitData> ruleUnitClass) {
        this.ruleUnitClass = ruleUnitClass;
        this.indexUnitVars();
    }

    public Class<?> getRuleUnitClass() {
        return this.ruleUnitClass;
    }

    public String getCanonicalName() {
        return this.getRuleUnitClass().getCanonicalName();
    }

    public String getSimpleName() {
        return this.ruleUnitClass.getSimpleName();
    }

    public String getPackageName() {
        Package aPackage = this.ruleUnitClass.getPackage();
        if (aPackage == null) {
            String canonicalName = this.ruleUnitClass.getCanonicalName();
            return canonicalName.substring(0, canonicalName.length() - this.getSimpleName().length() - 1);
        }
        return aPackage.getName();
    }

    public String getRuleUnitName() {
        return this.ruleUnitClass.getName();
    }

    private void indexUnitVars() {
        for (Method m : this.ruleUnitClass.getMethods()) {
            String id;
            if (m.getDeclaringClass() == RuleUnit.class || m.getParameterCount() != 0 || (id = ClassUtils.getter2property((String)m.getName())) == null || id.equals("class")) continue;
            Class<?> parametricType = this.getUnitVarType(m);
            this.putRuleUnitVariable(new SimpleRuleUnitVariable(id, m.getReturnType(), parametricType));
        }
    }

    private Class<?> getUnitVarType(Method m) {
        Class<?> returnClass = m.getReturnType();
        if (returnClass.isArray()) {
            return returnClass.getComponentType();
        }
        if (DataSource.class.isAssignableFrom(returnClass)) {
            return this.getParametricType(m);
        }
        if (Iterable.class.isAssignableFrom(returnClass)) {
            return this.getParametricType(m);
        }
        return null;
    }

    private Class<?> getParametricType(Method m) {
        Type returnType = m.getGenericReturnType();
        return returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getActualTypeArguments()[0] : Object.class;
    }
}

