/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules.units;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.kie.internal.ruleunit.RuleUnitDescription;
import org.kie.internal.ruleunit.RuleUnitVariable;

public abstract class AbstractRuleUnitDescription
implements RuleUnitDescription {
    private final Map<String, RuleUnitVariable> varDeclarations = new HashMap<String, RuleUnitVariable>();

    public Optional<Class<?>> getDatasourceType(String name) {
        return Optional.ofNullable(this.varDeclarations.get(name)).filter(RuleUnitVariable::isDataSource).map(RuleUnitVariable::getDataSourceParameterType);
    }

    public Optional<Class<?>> getVarType(String name) {
        return Optional.ofNullable(this.varDeclarations.get(name)).map(RuleUnitVariable::getType);
    }

    public boolean hasVar(String name) {
        return this.varDeclarations.containsKey(name);
    }

    public RuleUnitVariable getVar(String name) {
        return this.varDeclarations.get(name);
    }

    public Collection<String> getUnitVars() {
        return this.varDeclarations.keySet();
    }

    public Collection<RuleUnitVariable> getUnitVarDeclarations() {
        return this.varDeclarations.values();
    }

    public boolean hasDataSource(String name) {
        RuleUnitVariable ruleUnitVariable = this.varDeclarations.get(name);
        return ruleUnitVariable != null && ruleUnitVariable.isDataSource();
    }

    protected void putRuleUnitVariable(RuleUnitVariable varDeclaration) {
        this.varDeclarations.put(varDeclaration.getName(), varDeclaration);
    }
}

