/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules.units;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.drools.core.addon.TypeResolver;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.units.AbstractRuleUnitDescription;
import org.kie.kogito.rules.units.SimpleRuleUnitVariable;

public class GeneratedRuleUnitDescription
extends AbstractRuleUnitDescription {
    private final Function<String, Class<?>> typeResolver;
    private final String name;
    private final String packageName;
    private final String simpleName;

    public GeneratedRuleUnitDescription(String name, Function<String, Class<?>> typeResolver) {
        this.typeResolver = typeResolver;
        this.name = name;
        this.simpleName = name.substring(name.lastIndexOf(46) + 1);
        this.packageName = name.substring(0, name.lastIndexOf(46));
    }

    public GeneratedRuleUnitDescription(String name, TypeResolver typeResolver) {
        this(name, (String fqcn) -> GeneratedRuleUnitDescription.uncheckedLoadClass(typeResolver, fqcn));
    }

    public GeneratedRuleUnitDescription(String name, ClassLoader contextClassLoader) {
        this(name, (String fqcn) -> GeneratedRuleUnitDescription.uncheckedLoadClass(contextClassLoader, fqcn));
    }

    @Deprecated
    public Class<?> getRuleUnitClass() {
        return null;
    }

    public String getCanonicalName() {
        return this.getPackageName() + '.' + this.getSimpleName();
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRuleUnitName() {
        return this.name;
    }

    public void putSimpleVar(String name, String varTypeFQCN) {
        Class<?> varType = this.typeResolver.apply(varTypeFQCN);
        this.putSimpleVar(name, varType);
    }

    public void putDatasourceVar(String name, String datasourceTypeFQCN, String datasourceParameterTypeFQCN) {
        this.putDatasourceVar(name, this.typeResolver.apply(datasourceTypeFQCN), this.typeResolver.apply(datasourceParameterTypeFQCN));
    }

    public void putSimpleVar(String name, Class<?> varType) {
        this.putRuleUnitVariable(new SimpleRuleUnitVariable(name, varType));
    }

    public void putDatasourceVar(String name, Class<?> datasourceType, Class<?> datasourceParameterType) {
        this.putRuleUnitVariable(new SimpleRuleUnitVariable(name, datasourceType, datasourceParameterType));
    }

    private static Class<?> uncheckedLoadClass(TypeResolver typeResolver, String fqcn) {
        try {
            return typeResolver.resolveType(fqcn);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Class<?> uncheckedLoadClass(ClassLoader classLoader, String fqcn) {
        try {
            return classLoader.loadClass(fqcn);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Class<?> getUnitVarType(Method m) {
        Class<?> returnClass = m.getReturnType();
        if (returnClass.isArray()) {
            return returnClass.getComponentType();
        }
        if (DataSource.class.isAssignableFrom(returnClass)) {
            return this.getParametricType(m);
        }
        if (Iterable.class.isAssignableFrom(returnClass)) {
            return this.getParametricType(m);
        }
        return returnClass;
    }

    private Class<?> getParametricType(Method m) {
        Type returnType = m.getGenericReturnType();
        return returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getActualTypeArguments()[0] : Object.class;
    }
}

