/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.rules.units;

import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.RuleUnitQuery;

public abstract class AbstractRuleUnitInstance<E, T extends RuleUnitData> implements RuleUnitInstance<T> {

    private final T unitMemory;
    private final RuleUnit<T> unit;
    protected final E evaluator;

    public AbstractRuleUnitInstance(RuleUnit<T> unit, T unitMemory, E evaluator) {
        this.unit = unit;
        this.evaluator = evaluator;
        this.unitMemory = unitMemory;
        bind(evaluator, unitMemory);
    }

    @Override
    public <Q> Q executeQuery(Class<? extends RuleUnitQuery<Q>> query) {
        return createRuleUnitQuery(query).execute();
    }

    protected <Q> RuleUnitQuery<Q> createRuleUnitQuery(Class<? extends RuleUnitQuery<Q>> query) {
        try {
            return query.getConstructor(RuleUnitInstance.class).newInstance(this);
        } catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RuleUnit<T> unit() {
        return unit;
    }

    public T ruleUnitData() {
        return unitMemory;
    }

    public E getEvaluator() {
        return evaluator;
    }

    protected abstract void bind(E evaluator, T workingMemory);
}
