/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules.units;

import java.io.InputStream;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleUnitExecutorImpl;
import org.drools.core.io.impl.InputStreamResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.kogito.Application;
import org.kie.kogito.Config;
import org.kie.kogito.KogitoEngine;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.RuleUnits;
import org.kie.kogito.rules.units.InterpretedRuleUnitInstance;
import org.kie.kogito.rules.units.impl.AbstractRuleUnit;
import org.kie.kogito.rules.units.impl.AbstractRuleUnits;
import org.kie.kogito.uow.UnitOfWorkManager;

public class InterpretedRuleUnit<T extends RuleUnitData>
extends AbstractRuleUnit<T> {
    public static <T extends RuleUnitData> RuleUnit<T> of(Class<T> type) {
        return new InterpretedRuleUnit<T>(type.getCanonicalName());
    }

    private InterpretedRuleUnit(String id) {
        super(id, DummyApplication.INSTANCE);
    }

    @Override
    public RuleUnitInstance<T> internalCreateInstance(T data) {
        KnowledgeBuilderImpl kBuilder = new KnowledgeBuilderImpl();
        Class<?> wmClass = data.getClass();
        String canonicalName = wmClass.getCanonicalName();
        InputStream resourceAsStream = wmClass.getResourceAsStream(String.format("/%s.drl", canonicalName.replace('.', '/')));
        kBuilder.add((Resource)new InputStreamResource(resourceAsStream), ResourceType.DRL);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addPackages(kBuilder.getKnowledgePackages());
        RuleUnitExecutorImpl reteEvaluator = new RuleUnitExecutorImpl((RuleBase)kBase);
        return new InterpretedRuleUnitInstance<T>(this, data, (ReteEvaluator)reteEvaluator);
    }

    public static class DummyApplication
    implements Application {
        static final DummyApplication INSTANCE = new DummyApplication();
        RuleUnits ruleUnits = new RuleUnits();

        public Config config() {
            return null;
        }

        public <T extends KogitoEngine> T get(Class<T> clazz) {
            if (clazz.isAssignableFrom(org.kie.kogito.rules.RuleUnits.class)) {
                return (T)this.ruleUnits;
            }
            return null;
        }

        public UnitOfWorkManager unitOfWorkManager() {
            return null;
        }

        public static class RuleUnits
        extends AbstractRuleUnits {
            @Override
            protected RuleUnit<?> create(String fqcn) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

